/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.persist;

import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.ArrayUtil;
import org.evosuite.shaded.org.hsqldb.lib.DoubleIntIndex;
import org.evosuite.shaded.org.hsqldb.persist.DataSpaceManager;
import org.evosuite.shaded.org.hsqldb.persist.TableSpaceManager;

public class TableSpaceManagerBlocks
implements TableSpaceManager {
    DataSpaceManager spaceManager;
    private final int scale;
    int mainBlockSize;
    int spaceID;
    private DoubleIntIndex lookup;
    private final int capacity;
    private long releaseCount;
    private long requestCount;
    private long requestSize;
    boolean isModified;
    long freshBlockFreePos = 0L;
    long freshBlockLimit = 0L;

    public TableSpaceManagerBlocks(DataSpaceManager dataSpaceManager, int n, int n2, int n3, int n4) {
        this.spaceManager = dataSpaceManager;
        this.scale = n4;
        this.spaceID = n;
        this.mainBlockSize = n2;
        this.lookup = new DoubleIntIndex(n3, true);
        this.lookup.setValuesSearchTarget();
        this.capacity = n3;
    }

    @Override
    public boolean hasFileRoom(long l) {
        return this.freshBlockLimit - this.freshBlockFreePos > l;
    }

    @Override
    public void addFileBlock(long l, long l2) {
        int n = (int)(this.freshBlockLimit - this.freshBlockFreePos);
        if (n > 0) {
            this.release(this.freshBlockFreePos / (long)this.scale, n);
        }
        this.initialiseFileBlock(null, l, l2);
    }

    @Override
    public void initialiseFileBlock(DoubleIntIndex doubleIntIndex, long l, long l2) {
        this.freshBlockFreePos = l;
        this.freshBlockLimit = l2;
        if (doubleIntIndex != null) {
            doubleIntIndex.copyTo(this.lookup);
        }
    }

    boolean getNewMainBlock(long l) {
        long l2 = ((long)this.mainBlockSize + l) / (long)this.mainBlockSize;
        long l3 = l2 * (long)this.mainBlockSize;
        long l4 = this.spaceManager.getFileBlocks(this.spaceID, (int)l2);
        if (l4 < 0L) {
            return false;
        }
        if (l4 == this.freshBlockLimit) {
            this.freshBlockLimit += l3;
            return true;
        }
        long l5 = this.freshBlockLimit - this.freshBlockFreePos;
        if (l5 > 0L) {
            this.release(this.freshBlockFreePos / (long)this.scale, (int)l5);
        }
        this.freshBlockFreePos = l4;
        this.freshBlockLimit = l4 + l3;
        return true;
    }

    long getNewBlock(long l, boolean bl) {
        long l2;
        boolean bl2;
        if (bl) {
            l = (int)ArrayUtil.getBinaryMultipleCeiling(l, 4096L);
        }
        if (this.freshBlockFreePos + l > this.freshBlockLimit && !(bl2 = this.getNewMainBlock(l))) {
            throw Error.error(468);
        }
        long l3 = this.freshBlockFreePos;
        if (bl && (l2 = (l3 = ArrayUtil.getBinaryMultipleCeiling(l3, 4096L)) - this.freshBlockFreePos) > 0L) {
            this.release(this.freshBlockFreePos / (long)this.scale, (int)l2);
            this.freshBlockFreePos = l3;
        }
        this.freshBlockFreePos += l;
        return l3 / (long)this.scale;
    }

    @Override
    public int getSpaceID() {
        return this.spaceID;
    }

    @Override
    public synchronized void release(long l, int n) {
        this.isModified = true;
        ++this.releaseCount;
        if (this.lookup.size() == this.capacity) {
            this.resetList();
        }
        if (l < Integer.MAX_VALUE) {
            this.lookup.add(l, (long)n);
        }
    }

    @Override
    public synchronized long getFilePosition(long l, boolean bl) {
        if (this.capacity == 0) {
            return this.getNewBlock(l, bl);
        }
        if (bl) {
            l = (int)ArrayUtil.getBinaryMultipleCeiling(l, 4096L);
        }
        int n = -1;
        if (this.lookup.size() > 0) {
            n = (long)this.lookup.getValue(0) >= l ? 0 : (l > Integer.MAX_VALUE ? -1 : this.lookup.findFirstGreaterEqualKeyIndex((int)l));
        }
        if (n == -1) {
            return this.getNewBlock(l, bl);
        }
        if (bl) {
            long l2;
            while (n < this.lookup.size() && (l2 = (long)this.lookup.getKey(n)) % (long)(4096 / this.scale) != 0L) {
                ++n;
            }
            if (n == this.lookup.size()) {
                return this.getNewBlock(l, bl);
            }
        }
        ++this.requestCount;
        this.requestSize += l;
        int n2 = this.lookup.getValue(n);
        int n3 = n2 - (int)l;
        int n4 = this.lookup.getKey(n);
        this.lookup.remove(n);
        if (n3 > 0) {
            long l3 = (long)n4 + l / (long)this.scale;
            this.lookup.add(l3, (long)n3);
        }
        return n4;
    }

    @Override
    public void reset() {
        this.spaceManager.freeTableSpace(this.lookup, this.freshBlockFreePos, this.freshBlockLimit, true);
        this.freshBlockFreePos = 0L;
        this.freshBlockLimit = 0L;
    }

    @Override
    public long getLostBlocksSize() {
        return this.lookup.getTotalValues();
    }

    @Override
    public boolean isDefaultSpace() {
        return this.spaceID == 7;
    }

    private void resetList() {
        this.spaceManager.freeTableSpace(this.lookup, this.freshBlockFreePos, this.freshBlockFreePos, false);
    }
}

