/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.resources;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.evosuite.shaded.org.hsqldb.lib.HashMap;
import org.evosuite.shaded.org.hsqldb.lib.HsqlArrayList;

public final class ResourceBundleHandler {
    private static final Object mutex = new Object();
    private static Locale locale = Locale.getDefault();
    private static HashMap bundleHandleMap = new HashMap();
    private static HsqlArrayList bundleList = new HsqlArrayList();
    private static final String prefix = "org.evosuite.shaded.org.hsqldb.resources.";
    private static final Method newGetBundleMethod = ResourceBundleHandler.getNewGetBundleMethod();

    private ResourceBundleHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale() {
        Object object = mutex;
        synchronized (object) {
            return locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale locale) throws IllegalArgumentException {
        Object object = mutex;
        synchronized (object) {
            if (locale == null) {
                throw new IllegalArgumentException("null locale");
            }
            ResourceBundleHandler.locale = locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBundleHandle(String string, ClassLoader classLoader) {
        Integer n;
        String string2 = prefix + string;
        Object object = mutex;
        synchronized (object) {
            String string3 = locale.toString() + string2;
            n = (Integer)bundleHandleMap.get(string3);
            if (n == null) {
                ResourceBundle resourceBundle = ResourceBundleHandler.getBundle(string2, locale, classLoader);
                bundleList.add(resourceBundle);
                n = new Integer(bundleList.size() - 1);
                bundleHandleMap.put(string3, n);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(int n, String string) {
        String string2;
        ResourceBundle resourceBundle;
        Object object = mutex;
        synchronized (object) {
            resourceBundle = n < 0 || n >= bundleList.size() || string == null ? null : (ResourceBundle)bundleList.get(n);
        }
        if (resourceBundle == null) {
            string2 = null;
        } else {
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        return string2;
    }

    private static Method getNewGetBundleMethod() {
        Class<ResourceBundle> clazz = ResourceBundle.class;
        Class[] classArray = new Class[]{String.class, Locale.class, ClassLoader.class};
        try {
            return clazz.getMethod("getBundle", classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws NullPointerException, MissingResourceException {
        if (classLoader == null) {
            return ResourceBundle.getBundle(string, locale);
        }
        if (newGetBundleMethod == null) {
            return ResourceBundle.getBundle(string, locale);
        }
        try {
            return (ResourceBundle)newGetBundleMethod.invoke(null, string, locale, classLoader);
        }
        catch (Exception exception) {
            return ResourceBundle.getBundle(string, locale);
        }
    }
}

