/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import org.evosuite.shaded.org.hsqldb.Scanner;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.map.ValuePool;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputBase;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputInterface;
import org.evosuite.shaded.org.hsqldb.types.BinaryData;
import org.evosuite.shaded.org.hsqldb.types.BlobData;
import org.evosuite.shaded.org.hsqldb.types.BlobDataID;
import org.evosuite.shaded.org.hsqldb.types.ClobData;
import org.evosuite.shaded.org.hsqldb.types.ClobDataID;
import org.evosuite.shaded.org.hsqldb.types.IntervalMonthData;
import org.evosuite.shaded.org.hsqldb.types.IntervalSecondData;
import org.evosuite.shaded.org.hsqldb.types.IntervalType;
import org.evosuite.shaded.org.hsqldb.types.JavaObjectData;
import org.evosuite.shaded.org.hsqldb.types.TimeData;
import org.evosuite.shaded.org.hsqldb.types.TimestampData;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class RowInputText
extends RowInputBase
implements RowInputInterface {
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private int textLen;
    protected String text;
    protected int line;
    protected int field;
    protected int next = 0;
    protected boolean allQuoted;
    protected Scanner scanner;
    private int maxPooledStringLength = ValuePool.getMaxStringLength();

    public RowInputText(String string, String string2, String string3, boolean bl) {
        super(new byte[0]);
        this.scanner = new Scanner();
        if (string.endsWith("\n")) {
            this.fieldSepEnd = true;
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("\n")) {
            this.varSepEnd = true;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string3.endsWith("\n")) {
            this.longvarSepEnd = true;
            string3 = string3.substring(0, string3.length() - 1);
        }
        this.allQuoted = bl;
        this.fieldSep = string;
        this.varSep = string2;
        this.longvarSep = string3;
        this.fieldSepLen = string.length();
        this.varSepLen = string2.length();
        this.longvarSepLen = string3.length();
    }

    public void setSource(String string, long l, int n) {
        this.size = n;
        this.text = string;
        this.textLen = string.length();
        this.filePos = l;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getField(String string, int n, boolean bl) throws IOException {
        String string2 = null;
        try {
            int n2 = this.next;
            ++this.field;
            if (bl) {
                if (this.next >= this.textLen && n > 0) {
                    throw Error.error(488);
                }
                if (!this.text.endsWith(string)) throw Error.error(488);
                this.next = this.textLen - n;
            } else {
                this.next = this.text.indexOf(string, n2);
                if (this.next == -1) {
                    this.next = this.textLen;
                }
            }
            if (n2 > this.next) {
                n2 = this.next;
            }
            string2 = this.text.substring(n2, this.next);
            this.next += n;
            int n3 = string2.trim().length();
            if (n3 == 0) {
                return null;
            }
            if (n3 >= string2.length()) return string2;
            n3 = string2.length() - 1;
            while (string2.charAt(n3) < ' ') {
                --n3;
            }
            return string2.substring(0, n3 + 1);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{new Integer(this.field), exception.toString()};
            throw new IOException(Error.getMessage(41, 0, objectArray));
        }
    }

    @Override
    public String readString() throws IOException {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() throws IOException {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() throws IOException {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readInt();
    }

    @Override
    public int readInt() throws IOException {
        String string = this.readString();
        if (string == null) {
            return 0;
        }
        if ((string = string.trim()).length() == 0) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    @Override
    public long readLong() throws IOException {
        throw Error.runtimeError(201, "RowInputText");
    }

    @Override
    public int readType() throws IOException {
        return 0;
    }

    @Override
    protected boolean readNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) throws IOException {
        String string = null;
        switch (type.typeCode) {
            case 1: {
                string = this.readString();
                break;
            }
            case 12: {
                string = this.readVarString();
                break;
            }
            default: {
                string = this.readLongVarString();
            }
        }
        if (string == null) {
            return null;
        }
        if (string.length() > this.maxPooledStringLength) {
            return new String(string);
        }
        return ValuePool.getString(string);
    }

    @Override
    protected Integer readSmallint() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(string));
    }

    @Override
    protected Integer readInteger() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getInt(Integer.parseInt(string));
    }

    @Override
    protected Long readBigint() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return ValuePool.getLong(Long.parseLong(string));
    }

    @Override
    protected Double readReal() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return Double.valueOf(string);
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return new BigDecimal(string);
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTime(string);
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newDate(string);
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return this.scanner.newTimestamp(string);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval(string, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval(string, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected Object readOther() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        BinaryData binaryData = this.scanner.convertToBinary(string);
        if (binaryData.length(null) == 0L) {
            return null;
        }
        return new JavaObjectData(binaryData.getBytes());
    }

    @Override
    protected BinaryData readBit() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        BinaryData binaryData = this.scanner.convertToBit(string);
        return binaryData;
    }

    @Override
    protected BinaryData readBinary() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        BinaryData binaryData = this.scanner.convertToBinary(string);
        return binaryData;
    }

    @Override
    protected ClobData readClob() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        long l = Long.parseLong(string);
        return new ClobDataID(l);
    }

    @Override
    protected BlobData readBlob() throws IOException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        long l = Long.parseLong(string);
        return new BlobDataID(l);
    }

    @Override
    protected Object[] readArray(Type type) {
        throw Error.runtimeError(201, "RowInputText");
    }

    public int getLineNumber() {
        return this.line;
    }

    public void skippedLine() {
        ++this.line;
    }

    @Override
    public void reset() {
        this.text = "";
        this.textLen = 0;
        this.filePos = 0L;
        this.next = 0;
        this.field = 0;
        this.line = 0;
    }
}

