/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.evosuite.shaded.org.hsqldb.HsqlDateTime;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.Scanner;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.HsqlArrayList;
import org.evosuite.shaded.org.hsqldb.map.ValuePool;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputBase;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputInterface;
import org.evosuite.shaded.org.hsqldb.types.BinaryData;
import org.evosuite.shaded.org.hsqldb.types.BlobData;
import org.evosuite.shaded.org.hsqldb.types.BlobDataID;
import org.evosuite.shaded.org.hsqldb.types.ClobData;
import org.evosuite.shaded.org.hsqldb.types.ClobDataID;
import org.evosuite.shaded.org.hsqldb.types.DateTimeType;
import org.evosuite.shaded.org.hsqldb.types.IntervalMonthData;
import org.evosuite.shaded.org.hsqldb.types.IntervalSecondData;
import org.evosuite.shaded.org.hsqldb.types.IntervalType;
import org.evosuite.shaded.org.hsqldb.types.JavaObjectData;
import org.evosuite.shaded.org.hsqldb.types.NumberType;
import org.evosuite.shaded.org.hsqldb.types.TimeData;
import org.evosuite.shaded.org.hsqldb.types.TimestampData;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class RowInputTextLog
extends RowInputBase
implements RowInputInterface {
    Scanner scanner;
    String tableName = null;
    String schemaName = null;
    int statementType;
    Object value;
    boolean version18;
    boolean noSeparators;
    Calendar tempCalDefault = new GregorianCalendar();

    public RowInputTextLog() {
        super(new byte[0]);
        this.scanner = new Scanner();
    }

    public RowInputTextLog(boolean bl) {
        super(new byte[0]);
        this.scanner = new Scanner();
        this.version18 = bl;
    }

    public void setSource(String string) {
        this.scanner.reset(string);
        this.statementType = 1;
        this.scanner.scanNext();
        String string2 = this.scanner.getString();
        if (string2.equals("INSERT")) {
            this.statementType = 3;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
            this.scanner.scanNext();
        } else if (string2.equals("DELETE")) {
            this.statementType = 2;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
        } else if (string2.equals("COMMIT")) {
            this.statementType = 4;
        } else if (string2.equals("SET")) {
            this.scanner.scanNext();
            if ("SCHEMA".equals(this.scanner.getString())) {
                this.scanner.scanNext();
                this.schemaName = this.scanner.getString();
                this.statementType = 6;
            }
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected void readField() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        this.value = this.scanner.getValue();
    }

    protected void readNumberField(Type type) {
        boolean bl;
        this.readFieldPrefix();
        this.scanner.scanNext();
        boolean bl2 = bl = this.scanner.getTokenType() == 814;
        if (bl) {
            this.scanner.scanNext();
        }
        this.value = this.scanner.getValue();
        if (bl) {
            try {
                this.value = ((NumberType)this.scanner.getDataType()).negate(this.value);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    protected void readFieldPrefix() {
        if (!this.noSeparators) {
            this.scanner.scanNext();
            if (this.statementType == 2) {
                this.scanner.scanNext();
                this.scanner.scanNext();
            }
        }
    }

    @Override
    public String readString() throws IOException {
        this.readField();
        return (String)this.value;
    }

    @Override
    public short readShort() throws IOException {
        throw Error.runtimeError(201, "");
    }

    @Override
    public int readInt() throws IOException {
        throw Error.runtimeError(201, "");
    }

    @Override
    public long readLong() throws IOException {
        throw Error.runtimeError(201, "");
    }

    @Override
    public int readType() throws IOException {
        return 0;
    }

    @Override
    protected boolean readNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) throws IOException {
        this.readField();
        return (String)this.value;
    }

    @Override
    protected Integer readSmallint() throws IOException {
        this.readNumberField(Type.SQL_SMALLINT);
        return (Integer)this.value;
    }

    @Override
    protected Integer readInteger() throws IOException {
        this.readNumberField(Type.SQL_INTEGER);
        if (this.value instanceof Long) {
            this.value = Type.SQL_INTEGER.convertToDefaultType(null, this.value);
        }
        return (Integer)this.value;
    }

    @Override
    protected Long readBigint() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof BigDecimal) {
            return (Long)Type.SQL_BIGINT.convertToDefaultType(null, this.value);
        }
        return ValuePool.getLong(((Number)this.value).longValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Double readReal() throws IOException {
        this.readNumberField(Type.SQL_DOUBLE);
        if (this.value == null) {
            return null;
        }
        if (!this.scanner.scanSpecialIdentifier("/")) return (Double)this.value;
        this.scanner.scanNext();
        Object object = this.scanner.getValue();
        double d = ((Number)object).doubleValue();
        if (d != 0.0) throw Error.error(5584);
        if (((Number)this.value).doubleValue() == 1.0) {
            d = Double.NEGATIVE_INFINITY;
        } else if (((Number)this.value).doubleValue() == -1.0) {
            d = Double.POSITIVE_INFINITY;
        } else {
            if (((Number)this.value).doubleValue() != 0.0) throw Error.error(5584);
            d = Double.NaN;
        }
        this.value = d;
        return (Double)this.value;
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        this.readNumberField(type);
        if (this.value == null) {
            return null;
        }
        BigDecimal bigDecimal = (BigDecimal)type.convertToDefaultType(null, this.value);
        return bigDecimal;
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Time time = Time.valueOf((String)this.value);
            long l = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, time.getTime());
            l = HsqlDateTime.getNormalisedTime(l);
            return new TimeData((int)l / 1000, 0, 0);
        }
        return this.scanner.newTime((String)this.value);
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Date date = Date.valueOf((String)this.value);
            long l = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, date.getTime());
            l = HsqlDateTime.getNormalisedDate(l);
            return new TimestampData(l / 1000L);
        }
        return this.scanner.newDate((String)this.value);
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Timestamp timestamp = Timestamp.valueOf((String)this.value);
            long l = HsqlDateTime.convertMillisFromCalendar(this.tempCalDefault, timestamp.getTime());
            int n = timestamp.getNanos();
            DateTimeType cfr_ignored_0 = (DateTimeType)type;
            n = DateTimeType.normaliseFraction(n, type.scale);
            return new TimestampData(l / 1000L, n, 0);
        }
        return this.scanner.newTimestamp((String)this.value);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() throws IOException {
        this.readFieldPrefix();
        this.scanner.scanNext();
        String string = this.scanner.getString();
        this.value = null;
        if (string.equalsIgnoreCase("TRUE")) {
            this.value = Boolean.TRUE;
        } else if (string.equalsIgnoreCase("FALSE")) {
            this.value = Boolean.FALSE;
        }
        return (Boolean)this.value;
    }

    @Override
    protected Object readOther() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 880) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return new JavaObjectData(((BinaryData)this.value).getBytes());
    }

    @Override
    protected BinaryData readBit() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBitStringWithQuote();
        if (this.scanner.getTokenType() == 879) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected BinaryData readBinary() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 880) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected ClobData readClob() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long l = ((Number)this.value).longValue();
        return new ClobDataID(l);
    }

    @Override
    protected BlobData readBlob() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long l = ((Number)this.value).longValue();
        return new BlobDataID(l);
    }

    @Override
    protected Object[] readArray(Type type) throws IOException {
        type = type.collectionBaseType();
        this.readFieldPrefix();
        this.scanner.scanNext();
        String string = this.scanner.getString();
        this.value = null;
        if (string.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!string.equalsIgnoreCase("ARRAY")) {
            throw Error.error(5584);
        }
        this.scanner.scanNext();
        string = this.scanner.getString();
        if (!string.equalsIgnoreCase("[")) {
            throw Error.error(5584);
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.noSeparators = true;
        int n = 0;
        while (!this.scanner.scanSpecialIdentifier("]")) {
            if (n > 0 && !this.scanner.scanSpecialIdentifier(",")) {
                throw Error.error(5584);
            }
            Object object = this.readData(type);
            hsqlArrayList.add(object);
            ++n;
        }
        this.noSeparators = false;
        Object[] objectArray = new Object[hsqlArrayList.size()];
        hsqlArrayList.toArray(objectArray);
        return objectArray;
    }
}

