/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.evosuite.shaded.org.hsqldb.Database;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.Statement;
import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.lib.LineReader;
import org.evosuite.shaded.org.hsqldb.lib.StringConverter;
import org.evosuite.shaded.org.hsqldb.map.ValuePool;
import org.evosuite.shaded.org.hsqldb.result.Result;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputTextLog;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptReaderBase;
import org.evosuite.shaded.org.hsqldb.scriptio.ScriptWriterText;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class ScriptReaderText
extends ScriptReaderBase {
    LineReader dataStreamIn;
    RowInputTextLog rowIn;
    boolean isInsert;

    public ScriptReaderText(Database database) {
        super(database);
    }

    public ScriptReaderText(Database database, String string, boolean bl) throws IOException {
        super(database);
        InputStream inputStream = this.database.logger.getFileAccess().openInputStreamElement(string);
        inputStream = new BufferedInputStream(inputStream);
        if (bl) {
            inputStream = new GZIPInputStream(inputStream);
        }
        this.dataStreamIn = new LineReader(inputStream, "ISO-8859-1");
        this.rowIn = new RowInputTextLog(database.databaseProperties.isVersion18());
    }

    public ScriptReaderText(Database database, InputStream inputStream) {
        super(database);
        this.dataStreamIn = new LineReader(inputStream, "ISO-8859-1");
        this.rowIn = new RowInputTextLog(database.databaseProperties.isVersion18());
    }

    @Override
    protected void readDDL(Session session) {
        while (this.readLoggedStatement(session)) {
            Statement statement = null;
            Result result = null;
            if (this.rowIn.getStatementType() == 3) {
                this.isInsert = true;
                break;
            }
            try {
                statement = session.compileStatement(this.statement);
                result = session.executeCompiledStatement(statement, ValuePool.emptyObjectArray, 0);
            }
            catch (HsqlException hsqlException) {
                result = Result.newErrorResult(hsqlException);
            }
            if (result.isError() && statement != null && (statement.getType() == 48 || statement.getType() == 14 && result.getMainString().indexOf("org.evosuite.shaded.org.hsqldb.Library") > -1) || !result.isError()) continue;
            this.database.logger.logWarningEvent(result.getMainString(), result.getException());
            if (statement != null && statement.getType() == 14) continue;
            HsqlException hsqlException = Error.error(result.getException(), 461, 25, new Object[]{this.database.getCanonicalPath(), new Integer(this.lineCount), result.getMainString()});
            this.handleException(hsqlException);
        }
    }

    @Override
    protected void readExistingData(Session session) {
        try {
            String string = null;
            this.database.setReferentialIntegrity(false);
            while (this.isInsert || this.readLoggedStatement(session)) {
                if (this.statementType == 6) {
                    session.setSchema(this.currentSchema);
                } else if (this.statementType == 3) {
                    if (!this.rowIn.getTableName().equals(string)) {
                        string = this.rowIn.getTableName();
                        String string2 = session.getSchemaName(this.currentSchema);
                        this.currentTable = this.database.schemaManager.getUserTable(session, string, string2);
                        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
                    }
                    try {
                        this.currentTable.insertFromScript(session, this.currentStore, this.rowData);
                    }
                    catch (HsqlException hsqlException) {
                        this.handleException(hsqlException);
                    }
                } else {
                    throw Error.error(461, this.statement);
                }
                this.isInsert = false;
            }
            this.database.setReferentialIntegrity(true);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("readExistingData failed", throwable);
            throw Error.error(throwable, 461, 25, new Object[]{new Integer(this.lineCount), throwable.toString()});
        }
    }

    @Override
    public boolean readLoggedStatement(Session session) {
        if (!this.sessionChanged) {
            try {
                this.rawStatement = this.dataStreamIn.readLine();
            }
            catch (EOFException eOFException) {
                return false;
            }
            catch (IOException iOException) {
                throw Error.error(iOException, 452, null);
            }
            ++this.lineCount;
            this.statement = StringConverter.unicodeStringToString(this.rawStatement);
            if (this.statement == null) {
                return false;
            }
        }
        this.processStatement(session);
        return true;
    }

    void processStatement(Session session) {
        if (this.statement.startsWith("/*C")) {
            int n = this.statement.indexOf(42, 4);
            this.sessionNumber = Integer.parseInt(this.statement.substring(3, n));
            this.statement = this.statement.substring(n + 2);
            this.sessionChanged = true;
            this.statementType = 5;
            return;
        }
        this.sessionChanged = false;
        this.rowIn.setSource(this.statement);
        this.statementType = this.rowIn.getStatementType();
        if (this.statementType == 1) {
            this.rowData = null;
            this.currentTable = null;
            return;
        }
        if (this.statementType == 4) {
            this.rowData = null;
            this.currentTable = null;
            return;
        }
        if (this.statementType == 6) {
            this.rowData = null;
            this.currentTable = null;
            this.currentSchema = this.rowIn.getSchemaName();
            return;
        }
        String string = this.rowIn.getTableName();
        String string2 = session.getCurrentSchemaHsqlName().name;
        this.currentTable = this.database.schemaManager.getUserTable(session, string, string2);
        this.currentStore = this.database.persistentStoreCollection.getStore(this.currentTable);
        Type[] typeArray = this.statementType == 3 ? this.currentTable.getColumnTypes() : (this.currentTable.hasPrimaryKey() ? this.currentTable.getPrimaryKeyTypes() : this.currentTable.getColumnTypes());
        try {
            this.rowData = this.rowIn.readData(typeArray);
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 452, null);
        }
    }

    @Override
    public void close() {
        try {
            this.dataStreamIn.close();
            if (this.scrwriter != null) {
                this.scrwriter.close();
            }
            this.database.recoveryMode = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleException(HsqlException hsqlException) {
        if (this.database.recoveryMode == 0) {
            throw hsqlException;
        }
        if (this.scrwriter == null) {
            String string = this.database.getPath() + ".reject";
            this.scrwriter = new ScriptWriterText(this.database, string, true, true, true);
        }
        try {
            this.scrwriter.writeLogStatement(null, this.rawStatement);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

