/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.server;

import java.io.DataInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.evosuite.shaded.org.hsqldb.DatabaseManager;
import org.evosuite.shaded.org.hsqldb.DatabaseURL;
import org.evosuite.shaded.org.hsqldb.HsqlException;
import org.evosuite.shaded.org.hsqldb.Session;
import org.evosuite.shaded.org.hsqldb.lib.DataOutputStream;
import org.evosuite.shaded.org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.evosuite.shaded.org.hsqldb.persist.HsqlProperties;
import org.evosuite.shaded.org.hsqldb.result.Result;
import org.evosuite.shaded.org.hsqldb.rowio.RowInputBinary;
import org.evosuite.shaded.org.hsqldb.rowio.RowOutputBinary;

public class Servlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 256;
    private String dbType;
    private String dbPath;
    private String errorStr;
    private RowOutputBinary rowOut;
    private RowInputBinary rowIn;
    private int iQueries;
    private static long lModified = 0L;

    public void init(ServletConfig servletConfig) {
        try {
            super.init(servletConfig);
            this.rowOut = new RowOutputBinary(256, 1);
            this.rowIn = new RowInputBinary(this.rowOut);
        }
        catch (ServletException servletException) {
            this.log(servletException.toString());
        }
        String string = this.getInitParameter("hsqldb.server.database");
        if (string == null) {
            string = ".";
        }
        String string2 = this.getInitParameter("hsqldb.server.use_web-inf_path");
        if (!string.equals(".") && "true".equalsIgnoreCase(string2)) {
            string = this.getServletContext().getRealPath("/") + "WEB-INF/" + string;
        }
        HsqlProperties hsqlProperties = DatabaseURL.parseURL(string, false, false);
        this.log("Database filename = " + string);
        if (hsqlProperties == null) {
            this.errorStr = "Bad Database name";
        } else {
            this.dbPath = hsqlProperties.getProperty("database");
            this.dbType = hsqlProperties.getProperty("connection_type");
            try {
                DatabaseManager.getDatabase(this.dbType, this.dbPath, hsqlProperties);
            }
            catch (HsqlException hsqlException) {
                this.errorStr = hsqlException.getMessage();
            }
        }
        if (this.errorStr == null) {
            this.log("Initialization completed.");
        } else {
            this.log("Database could not be initialised.");
            this.log(this.errorStr);
        }
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return lModified++;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getQueryString();
        if (string == null || string.length() == 0) {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("Pragma", "no-cache");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<html><head><title>HSQL Database Engine Servlet</title>");
            printWriter.println("</head><body><h1>HSQL Database Engine Servlet</h1>");
            printWriter.println("The servlet is running.<p>");
            if (this.errorStr == null) {
                printWriter.println("The database is also running.<p>");
                printWriter.println("Database name: " + this.dbType + this.dbPath + "<p>");
                printWriter.println("Queries processed: " + this.iQueries + "<p>");
            } else {
                printWriter.println("<h2>The database is not running!</h2>");
                printWriter.println("The error message is:<p>");
                printWriter.println(this.errorStr);
            }
            printWriter.println("</body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Servlet servlet = this;
        synchronized (servlet) {
            DataInputStream dataInputStream = null;
            FilterOutputStream filterOutputStream = null;
            try {
                Result result;
                dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
                int n = dataInputStream.readInt();
                long l = dataInputStream.readLong();
                byte by = dataInputStream.readByte();
                Session session = DatabaseManager.getSession(n, l);
                Result result2 = Result.newResult(session, by, dataInputStream, this.rowIn);
                result2.setDatabaseId(n);
                result2.setSessionId(l);
                int n2 = result2.getType();
                if (n2 == 31) {
                    try {
                        session = DatabaseManager.newSession(this.dbType, this.dbPath, result2.getMainString(), result2.getSubString(), new HsqlProperties(), result2.getZoneString(), result2.getUpdateCount());
                        result2.readAdditionalResults(null, dataInputStream, this.rowIn);
                        result = Result.newConnectionAcknowledgeResponse(session.getDatabase(), session.getId(), session.getDatabase().getDatabaseID());
                    }
                    catch (HsqlException hsqlException) {
                        result = Result.newErrorResult(hsqlException);
                    }
                } else {
                    if (n2 == 32 || n2 == 10) {
                        httpServletResponse.setHeader("Cache-Control", "no-cache");
                        httpServletResponse.setContentType("application/octet-stream");
                        httpServletResponse.setContentLength(6);
                        filterOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
                        ((DataOutputStream)filterOutputStream).writeByte(32);
                        ((DataOutputStream)filterOutputStream).writeInt(4);
                        ((DataOutputStream)filterOutputStream).writeByte(0);
                        filterOutputStream.close();
                        return;
                    }
                    int n3 = result2.getDatabaseId();
                    long l2 = result2.getSessionId();
                    session = DatabaseManager.getSession(n3, l2);
                    result2.readLobResults(session, dataInputStream, this.rowIn);
                    result = session.execute(result2);
                }
                HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(hsqlByteArrayOutputStream);
                result.write(session, dataOutputStream, this.rowOut);
                httpServletResponse.setHeader("Cache-Control", "no-cache");
                httpServletResponse.setContentType("application/octet-stream");
                httpServletResponse.setContentLength(hsqlByteArrayOutputStream.size());
                filterOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
                hsqlByteArrayOutputStream.writeTo(filterOutputStream);
                ++this.iQueries;
            }
            catch (HsqlException hsqlException) {
            }
            finally {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
            }
        }
    }
}

