/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hsqldb.types;

import org.evosuite.shaded.org.hsqldb.error.Error;
import org.evosuite.shaded.org.hsqldb.types.DTIType;
import org.evosuite.shaded.org.hsqldb.types.IntervalType;
import org.evosuite.shaded.org.hsqldb.types.Type;

public class IntervalSecondData {
    public static final IntervalSecondData oneDay = IntervalSecondData.newIntervalDay(1L, Type.SQL_INTERVAL_DAY);
    final long units;
    final int nanos;

    public static IntervalSecondData newInterval(double d, int n) {
        int n2 = DTIType.intervalIndexMap.get(n);
        return new IntervalSecondData((long)(d *= (double)DTIType.yearToSecondFactors[n2]), 0);
    }

    public static IntervalSecondData newIntervalDay(long l, IntervalType intervalType) {
        return new IntervalSecondData(l * 24L * 60L * 60L, 0, intervalType);
    }

    public static IntervalSecondData newIntervalHour(long l, IntervalType intervalType) {
        return new IntervalSecondData(l * 60L * 60L, 0, intervalType);
    }

    public static IntervalSecondData newIntervalMinute(long l, IntervalType intervalType) {
        return new IntervalSecondData(l * 60L, 0, intervalType);
    }

    public static IntervalSecondData newIntervalSeconds(long l, IntervalType intervalType) {
        return new IntervalSecondData(l, 0, intervalType);
    }

    public IntervalSecondData(long l, int n, IntervalType intervalType) {
        if (l >= intervalType.getIntervalValueLimit()) {
            throw Error.error(3435);
        }
        this.units = l;
        this.nanos = n;
    }

    public IntervalSecondData(long l, int n) {
        this.units = l;
        this.nanos = n;
    }

    public IntervalSecondData(long l, long l2, IntervalType intervalType, boolean bl) {
        if (l2 >= 1000000000L) {
            long l3 = l2 / 1000000000L;
            l2 %= 1000000000L;
            l += l3;
        } else if (l2 <= -1000000000L) {
            long l4 = -l2 / 1000000000L;
            l2 = -(-l2 % 1000000000L);
            l -= l4;
        }
        int n = DTIType.nanoScaleFactors[intervalType.scale];
        l2 /= (long)n;
        if (l > 0L && (l2 *= (long)n) < 0L) {
            l2 += 1000000000L;
            --l;
        } else if (l < 0L && l2 > 0L) {
            l2 -= 1000000000L;
            ++l;
        }
        n = DTIType.yearToSecondFactors[intervalType.endPartIndex];
        l /= (long)n;
        if ((l *= (long)n) >= intervalType.getIntervalValueLimit()) {
            throw Error.error(3435);
        }
        this.units = l;
        this.nanos = (int)l2;
    }

    public boolean equals(Object object) {
        if (object instanceof IntervalSecondData) {
            return this.units == ((IntervalSecondData)object).units && this.nanos == ((IntervalSecondData)object).nanos;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.units ^ this.nanos;
    }

    public int compareTo(IntervalSecondData intervalSecondData) {
        if (this.units > intervalSecondData.units) {
            return 1;
        }
        if (this.units < intervalSecondData.units) {
            return -1;
        }
        if (this.nanos > intervalSecondData.nanos) {
            return 1;
        }
        if (this.nanos < intervalSecondData.nanos) {
            return -1;
        }
        return 0;
    }

    public long getSeconds() {
        return this.units;
    }

    public int getNanos() {
        return this.nanos;
    }

    public String toString() {
        return Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION.convertToString(this);
    }
}

