/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.jboss.jandex;

import org.evosuite.shaded.org.jboss.jandex.AnnotationInstance;
import org.evosuite.shaded.org.jboss.jandex.DotName;
import org.evosuite.shaded.org.jboss.jandex.Type;

public abstract class AnnotationValue {
    static final AnnotationValue[] EMPTY_VALUE_ARRAY = new AnnotationValue[0];
    private final String name;

    AnnotationValue(String name) {
        this.name = name;
    }

    public static final AnnotationValue createByteValue(String name, byte b) {
        return new ByteValue(name, b);
    }

    public static final AnnotationValue createShortValue(String name, short s) {
        return new ShortValue(name, s);
    }

    public static final AnnotationValue createIntegerValue(String name, int i) {
        return new IntegerValue(name, i);
    }

    public static final AnnotationValue createCharacterValue(String name, char c) {
        return new CharacterValue(name, c);
    }

    public static final AnnotationValue createFloatValue(String name, float f) {
        return new FloatValue(name, f);
    }

    public static final AnnotationValue createDouleValue(String name, double d) {
        return new DoubleValue(name, d);
    }

    public static final AnnotationValue createLongalue(String name, long l) {
        return new LongValue(name, l);
    }

    public static final AnnotationValue createBooleanValue(String name, boolean bool) {
        return new BooleanValue(name, bool);
    }

    public static final AnnotationValue createStringValue(String name, String string) {
        return new StringValue(name, string);
    }

    public static final AnnotationValue createClassValue(String name, Type type) {
        return new ClassValue(name, type);
    }

    public static final AnnotationValue createEnumValue(String name, DotName typeName, String value) {
        return new EnumValue(name, typeName, value);
    }

    public static final AnnotationValue createArrayValue(String name, AnnotationValue[] values) {
        return new ArrayValue(name, values);
    }

    public static final AnnotationValue createNestedAnnotationValue(String name, AnnotationInstance instance) {
        return new NestedAnnotation(name, instance);
    }

    public final String name() {
        return this.name;
    }

    public abstract Object value();

    public int asInt() {
        throw new IllegalArgumentException("Not a number");
    }

    public long asLong() {
        throw new IllegalArgumentException("Not a number");
    }

    public short asShort() {
        throw new IllegalArgumentException("not a number");
    }

    public byte asByte() {
        throw new IllegalArgumentException("not a number");
    }

    public float asFloat() {
        throw new IllegalArgumentException("not a number");
    }

    public double asDouble() {
        throw new IllegalArgumentException("not a number");
    }

    public char asChar() {
        throw new IllegalArgumentException("not a character");
    }

    public boolean asBoolean() {
        throw new IllegalArgumentException("not a boolean");
    }

    public String asString() {
        return this.value().toString();
    }

    public String asEnum() {
        throw new IllegalArgumentException("not an enum");
    }

    public DotName asEnumType() {
        throw new IllegalArgumentException("not an enum");
    }

    public Type asClass() {
        throw new IllegalArgumentException("not a class");
    }

    public AnnotationInstance asNested() {
        throw new IllegalArgumentException("not a nested annotation");
    }

    AnnotationValue[] asArray() {
        throw new IllegalArgumentException("Not an array");
    }

    public int[] asIntArray() {
        throw new IllegalArgumentException("Not a numerical array");
    }

    public long[] asLongArray() {
        throw new IllegalArgumentException("Not a numerical array");
    }

    public short[] asShortArray() {
        throw new IllegalArgumentException("not a numerical array");
    }

    public byte[] asByteArray() {
        throw new IllegalArgumentException("not a numerical array");
    }

    public float[] asFloatArray() {
        throw new IllegalArgumentException("not a numerical array");
    }

    public double[] asDoubleArray() {
        throw new IllegalArgumentException("not a numerical array");
    }

    public char[] asCharArray() {
        throw new IllegalArgumentException("not a character array");
    }

    public boolean[] asBooleanArray() {
        throw new IllegalArgumentException("not a boolean array");
    }

    public String[] asStringArray() {
        throw new IllegalArgumentException("not a string array");
    }

    public String[] asEnumArray() {
        throw new IllegalArgumentException("not an enum array");
    }

    public DotName[] asEnumTypeArray() {
        throw new IllegalArgumentException("not an enum array");
    }

    public Type[] asClassArray() {
        throw new IllegalArgumentException("not a class array");
    }

    public AnnotationInstance[] asNestedArray() {
        throw new IllegalArgumentException("not a nested annotation array");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name.length() > 0) {
            builder.append(this.name).append(" = ");
        }
        return builder.append(this.value()).toString();
    }

    static final class ArrayValue
    extends AnnotationValue {
        private final AnnotationValue[] value;

        ArrayValue(String name, AnnotationValue[] value) {
            super(name);
            this.value = value.length > 0 ? value : EMPTY_VALUE_ARRAY;
        }

        public AnnotationValue[] value() {
            return this.value;
        }

        @Override
        AnnotationValue[] asArray() {
            return this.value;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (((AnnotationValue)this).name.length() > 0) {
                builder.append(((AnnotationValue)this).name).append(" = ");
            }
            builder.append('[');
            for (int i = 0; i < this.value.length; ++i) {
                builder.append(this.value[i]);
                if (i >= this.value.length - 1) continue;
                builder.append(',');
            }
            return builder.append(']').toString();
        }

        @Override
        public int[] asIntArray() {
            int length = this.value.length;
            int[] array = new int[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asInt();
            }
            return array;
        }

        @Override
        public long[] asLongArray() {
            int length = this.value.length;
            long[] array = new long[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asLong();
            }
            return array;
        }

        @Override
        public short[] asShortArray() {
            int length = this.value.length;
            short[] array = new short[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asShort();
            }
            return array;
        }

        @Override
        public byte[] asByteArray() {
            int length = this.value.length;
            byte[] array = new byte[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asByte();
            }
            return array;
        }

        @Override
        public float[] asFloatArray() {
            int length = this.value.length;
            float[] array = new float[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asFloat();
            }
            return array;
        }

        @Override
        public double[] asDoubleArray() {
            int length = this.value.length;
            double[] array = new double[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asDouble();
            }
            return array;
        }

        @Override
        public char[] asCharArray() {
            int length = this.value.length;
            char[] array = new char[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asChar();
            }
            return array;
        }

        @Override
        public boolean[] asBooleanArray() {
            int length = this.value.length;
            boolean[] array = new boolean[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asBoolean();
            }
            return array;
        }

        @Override
        public String[] asStringArray() {
            int length = this.value.length;
            String[] array = new String[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asString();
            }
            return array;
        }

        @Override
        public String[] asEnumArray() {
            int length = this.value.length;
            String[] array = new String[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asEnum();
            }
            return array;
        }

        @Override
        public Type[] asClassArray() {
            int length = this.value.length;
            Type[] array = new Type[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asClass();
            }
            return array;
        }

        @Override
        public AnnotationInstance[] asNestedArray() {
            int length = this.value.length;
            AnnotationInstance[] array = new AnnotationInstance[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asNested();
            }
            return array;
        }

        @Override
        public DotName[] asEnumTypeArray() {
            int length = this.value.length;
            DotName[] array = new DotName[length];
            for (int i = 0; i < length; ++i) {
                array[i] = this.value[i].asEnumType();
            }
            return array;
        }
    }

    static final class NestedAnnotation
    extends AnnotationValue {
        private final AnnotationInstance value;

        NestedAnnotation(String name, AnnotationInstance value) {
            super(name);
            this.value = value;
        }

        @Override
        public AnnotationInstance value() {
            return this.value;
        }

        @Override
        public AnnotationInstance asNested() {
            return this.value;
        }
    }

    static final class ClassValue
    extends AnnotationValue {
        private final Type type;

        ClassValue(String name, Type type) {
            super(name);
            this.type = type;
        }

        @Override
        public Type value() {
            return this.type;
        }

        @Override
        public Type asClass() {
            return this.type;
        }
    }

    static final class EnumValue
    extends AnnotationValue {
        private final String value;
        private final DotName typeName;

        EnumValue(String name, DotName typeName, String value) {
            super(name);
            this.typeName = typeName;
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String asEnum() {
            return this.value;
        }

        @Override
        public DotName asEnumType() {
            return this.typeName;
        }
    }

    static final class BooleanValue
    extends AnnotationValue {
        private final boolean value;

        BooleanValue(String name, boolean value) {
            super(name);
            this.value = value;
        }

        @Override
        public Boolean value() {
            return this.value;
        }

        @Override
        public boolean asBoolean() {
            return this.value;
        }
    }

    static final class LongValue
    extends AnnotationValue {
        private final long value;

        LongValue(String name, long value) {
            super(name);
            this.value = value;
        }

        @Override
        public Long value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return (int)this.value;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public short asShort() {
            return (short)this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class IntegerValue
    extends AnnotationValue {
        private final int value;

        IntegerValue(String name, int value) {
            super(name);
            this.value = value;
        }

        @Override
        public Integer value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return this.value;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public short asShort() {
            return (short)this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class ShortValue
    extends AnnotationValue {
        private final short value;

        ShortValue(String name, short value) {
            super(name);
            this.value = value;
        }

        @Override
        public Short value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return this.value;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public short asShort() {
            return this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class FloatValue
    extends AnnotationValue {
        private final float value;

        FloatValue(String name, float value) {
            super(name);
            this.value = value;
        }

        @Override
        public Float value() {
            return Float.valueOf(this.value);
        }

        @Override
        public int asInt() {
            return (int)this.value;
        }

        @Override
        public long asLong() {
            return (long)this.value;
        }

        @Override
        public short asShort() {
            return (short)this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class DoubleValue
    extends AnnotationValue {
        private final double value;

        public DoubleValue(String name, double value) {
            super(name);
            this.value = value;
        }

        @Override
        public Double value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return (int)this.value;
        }

        @Override
        public long asLong() {
            return (long)this.value;
        }

        @Override
        public short asShort() {
            return (short)this.value;
        }

        @Override
        public byte asByte() {
            return (byte)this.value;
        }

        @Override
        public float asFloat() {
            return (float)this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class CharacterValue
    extends AnnotationValue {
        private final char value;

        CharacterValue(String name, char value) {
            super(name);
            this.value = value;
        }

        @Override
        public Character value() {
            return Character.valueOf(this.value);
        }

        @Override
        public char asChar() {
            return this.value;
        }
    }

    static final class ByteValue
    extends AnnotationValue {
        private final byte value;

        ByteValue(String name, byte value) {
            super(name);
            this.value = value;
        }

        @Override
        public Byte value() {
            return this.value;
        }

        @Override
        public int asInt() {
            return this.value;
        }

        @Override
        public long asLong() {
            return this.value;
        }

        @Override
        public short asShort() {
            return this.value;
        }

        @Override
        public byte asByte() {
            return this.value;
        }

        @Override
        public float asFloat() {
            return this.value;
        }

        @Override
        public double asDouble() {
            return this.value;
        }
    }

    static final class StringValue
    extends AnnotationValue {
        private final String value;

        StringValue(String name, String value) {
            super(name);
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (((AnnotationValue)this).name.length() > 0) {
                builder.append(((AnnotationValue)this).name).append(" = ");
            }
            return builder.append('\"').append(this.value).append('\"').toString();
        }
    }
}

