/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.jboss.jandex;

import org.evosuite.shaded.org.jboss.jandex.AnnotationTarget;
import org.evosuite.shaded.org.jboss.jandex.ClassInfo;
import org.evosuite.shaded.org.jboss.jandex.Type;

public final class MethodInfo
implements AnnotationTarget {
    private final String name;
    private final Type[] args;
    private final Type returnType;
    private final short flags;
    private final ClassInfo clazz;

    MethodInfo(ClassInfo clazz, String name, Type[] args, Type returnType, short flags) {
        this.clazz = clazz;
        this.name = name;
        this.args = args;
        this.returnType = returnType;
        this.flags = flags;
    }

    public static final MethodInfo create(ClassInfo clazz, String name, Type[] args, Type returnType, short flags) {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name can't be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Values can't be null");
        }
        if (returnType == null) {
            throw new IllegalArgumentException("returnType can't be null");
        }
        return new MethodInfo(clazz, name, args, returnType, flags);
    }

    public final String name() {
        return this.name;
    }

    public final ClassInfo declaringClass() {
        return this.clazz;
    }

    public final Type[] args() {
        return this.args;
    }

    public final Type returnType() {
        return this.returnType;
    }

    public final short flags() {
        return this.flags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.returnType).append(' ').append(this.clazz.name()).append('.').append(this.name).append('(');
        for (int i = 0; i < this.args.length; ++i) {
            builder.append(this.args[i]);
            if (i + 1 >= this.args.length) continue;
            builder.append(", ");
        }
        builder.append(')');
        return builder.toString();
    }
}

