/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.jboss.jandex;

import org.evosuite.shaded.org.jboss.jandex.DotName;

public final class Type {
    private final DotName name;
    private final Kind kind;

    Type(DotName name, Kind kind) {
        this.name = name;
        this.kind = kind;
    }

    public static final Type create(DotName name, Kind kind) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null!");
        }
        if (kind == null) {
            throw new IllegalArgumentException("kind can not be null!");
        }
        return new Type(name, kind);
    }

    public DotName name() {
        return this.name;
    }

    public Kind kind() {
        return this.kind;
    }

    public String toString() {
        return this.name.toString();
    }

    public static enum Kind {
        CLASS,
        ARRAY,
        PRIMITIVE,
        VOID;


        public static Kind fromOrdinal(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return CLASS;
                }
                case 1: {
                    return ARRAY;
                }
                case 2: {
                    return PRIMITIVE;
                }
            }
            return VOID;
        }
    }
}

