/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.jboss.logging;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.evosuite.shaded.org.jboss.logging.JBossLogRecord;
import org.evosuite.shaded.org.jboss.logging.JDKLevel;
import org.evosuite.shaded.org.jboss.logging.Logger;

final class JDKLogger
extends Logger {
    private static final long serialVersionUID = 2563174097983721393L;
    private final transient java.util.logging.Logger logger;

    public JDKLogger(String name) {
        super(name);
        this.logger = java.util.logging.Logger.getLogger(name);
    }

    @Override
    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        if (this.isEnabled(level)) {
            try {
                JBossLogRecord rec = new JBossLogRecord(JDKLogger.translate(level), String.valueOf(message), loggerClassName);
                if (thrown != null) {
                    rec.setThrown(thrown);
                }
                rec.setLoggerName(this.getName());
                rec.setParameters(parameters);
                rec.setResourceBundleName(this.logger.getResourceBundleName());
                rec.setResourceBundle(this.logger.getResourceBundle());
                this.logger.log(rec);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    @Override
    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        if (this.isEnabled(level)) {
            try {
                ResourceBundle resourceBundle = this.logger.getResourceBundle();
                if (resourceBundle != null) {
                    try {
                        format = resourceBundle.getString(format);
                    }
                    catch (MissingResourceException e) {
                        // empty catch block
                    }
                }
                String msg = parameters == null ? String.format(format, new Object[0]) : String.format(format, parameters);
                JBossLogRecord rec = new JBossLogRecord(JDKLogger.translate(level), msg, loggerClassName);
                if (thrown != null) {
                    rec.setThrown(thrown);
                }
                rec.setLoggerName(this.getName());
                rec.setResourceBundleName(this.logger.getResourceBundleName());
                rec.setResourceBundle(null);
                rec.setParameters(null);
                this.logger.log(rec);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    private static Level translate(Logger.Level level) {
        if (level != null) {
            switch (level) {
                case FATAL: {
                    return JDKLevel.FATAL;
                }
                case ERROR: {
                    return JDKLevel.ERROR;
                }
                case WARN: {
                    return JDKLevel.WARN;
                }
                case INFO: {
                    return JDKLevel.INFO;
                }
                case DEBUG: {
                    return JDKLevel.DEBUG;
                }
                case TRACE: {
                    return JDKLevel.TRACE;
                }
            }
        }
        return JDKLevel.ALL;
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        return this.logger.isLoggable(JDKLogger.translate(level));
    }
}

