/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.jboss.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.LogManager;
import org.evosuite.shaded.org.jboss.logging.JBossLogManagerProvider;
import org.evosuite.shaded.org.jboss.logging.JDKLoggerProvider;
import org.evosuite.shaded.org.jboss.logging.Log4jLoggerProvider;
import org.evosuite.shaded.org.jboss.logging.LoggerProvider;
import org.evosuite.shaded.org.jboss.logging.Slf4jLoggerProvider;

final class LoggerProviders {
    static final String LOGGING_PROVIDER_KEY = "org.evosuite.shaded.org.jboss.logging.provider";
    static final LoggerProvider PROVIDER = LoggerProviders.find();

    private static LoggerProvider find() {
        LoggerProvider result = LoggerProviders.findProvider();
        result.getLogger("org.evosuite.shaded.org.jboss.logging").debugf("Logging Provider: %s", (Object)result.getClass().getName());
        return result;
    }

    private static LoggerProvider findProvider() {
        ClassLoader cl = LoggerProviders.class.getClassLoader();
        try {
            String loggerProvider = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(LoggerProviders.LOGGING_PROVIDER_KEY);
                }
            });
            if (loggerProvider != null) {
                if ("jboss".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.tryJBossLogManager(cl);
                }
                if ("jdk".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.tryJDK();
                }
                if ("log4j".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.tryLog4j(cl);
                }
                if ("slf4j".equalsIgnoreCase(loggerProvider)) {
                    return LoggerProviders.trySlf4j();
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            return LoggerProviders.tryJBossLogManager(cl);
        }
        catch (Throwable t) {
            try {
                return LoggerProviders.tryLog4j(cl);
            }
            catch (Throwable t2) {
                try {
                    Class.forName("ch.qos.logback.classic.Logger", false, cl);
                    return LoggerProviders.trySlf4j();
                }
                catch (Throwable throwable) {
                    return LoggerProviders.tryJDK();
                }
            }
        }
    }

    private static JDKLoggerProvider tryJDK() {
        return new JDKLoggerProvider();
    }

    private static LoggerProvider trySlf4j() {
        return new Slf4jLoggerProvider();
    }

    private static LoggerProvider tryLog4j(ClassLoader cl) throws ClassNotFoundException {
        Class.forName("org.apache.log4j.LogManager", true, cl);
        Class.forName("org.apache.log4j.Hierarchy", true, cl);
        return new Log4jLoggerProvider();
    }

    private static LoggerProvider tryJBossLogManager(ClassLoader cl) throws ClassNotFoundException {
        Class<?> logManagerClass = LogManager.getLogManager().getClass();
        if (logManagerClass == Class.forName("org.evosuite.shaded.org.jboss.logmanager.LogManager", false, cl) && Class.forName("org.evosuite.shaded.org.jboss.logmanager.Logger$AttachmentKey", true, cl).getClassLoader() == logManagerClass.getClassLoader()) {
            return new JBossLogManagerProvider();
        }
        throw new IllegalStateException();
    }

    private LoggerProviders() {
    }
}

