/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.beans.factory.support;

import org.evosuite.shaded.org.springframework.beans.MutablePropertyValues;
import org.evosuite.shaded.org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.evosuite.shaded.org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.evosuite.shaded.org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.evosuite.shaded.org.springframework.util.ObjectUtils;

public class ChildBeanDefinition
extends AbstractBeanDefinition {
    private String parentName;

    public ChildBeanDefinition(String parentName) {
        this.parentName = parentName;
    }

    public ChildBeanDefinition(String parentName, MutablePropertyValues pvs) {
        super(null, pvs);
        this.parentName = parentName;
    }

    public ChildBeanDefinition(String parentName, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.parentName = parentName;
    }

    public ChildBeanDefinition(String parentName, Class<?> beanClass, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.parentName = parentName;
        this.setBeanClass(beanClass);
    }

    public ChildBeanDefinition(String parentName, String beanClassName, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.parentName = parentName;
        this.setBeanClassName(beanClassName);
    }

    public ChildBeanDefinition(ChildBeanDefinition original) {
        super(original);
    }

    @Override
    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public void validate() throws BeanDefinitionValidationException {
        super.validate();
        if (this.parentName == null) {
            throw new BeanDefinitionValidationException("'parentName' must be set in ChildBeanDefinition");
        }
    }

    @Override
    public AbstractBeanDefinition cloneBeanDefinition() {
        return new ChildBeanDefinition(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChildBeanDefinition)) {
            return false;
        }
        ChildBeanDefinition that = (ChildBeanDefinition)other;
        return ObjectUtils.nullSafeEquals(this.parentName, that.parentName) && super.equals(other);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.parentName) * 29 + super.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Child bean with parent '");
        sb.append(this.parentName).append("': ").append(super.toString());
        return sb.toString();
    }
}

