/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.evosuite.shaded.org.springframework.aop.support.AopUtils;
import org.evosuite.shaded.org.springframework.cache.interceptor.MethodCacheKey;
import org.evosuite.shaded.org.springframework.cache.interceptor.VariableNotAvailableException;
import org.evosuite.shaded.org.springframework.core.ParameterNameDiscoverer;
import org.evosuite.shaded.org.springframework.expression.spel.support.StandardEvaluationContext;
import org.evosuite.shaded.org.springframework.util.ObjectUtils;

class CacheEvaluationContext
extends StandardEvaluationContext {
    private final ParameterNameDiscoverer paramDiscoverer;
    private final Method method;
    private final Object[] args;
    private final Class<?> targetClass;
    private final Map<MethodCacheKey, Method> methodCache;
    private final List<String> unavailableVariables;
    private boolean paramLoaded = false;

    CacheEvaluationContext(Object rootObject, ParameterNameDiscoverer paramDiscoverer, Method method, Object[] args, Class<?> targetClass, Map<MethodCacheKey, Method> methodCache) {
        super(rootObject);
        this.paramDiscoverer = paramDiscoverer;
        this.method = method;
        this.args = args;
        this.targetClass = targetClass;
        this.methodCache = methodCache;
        this.unavailableVariables = new ArrayList<String>();
    }

    public void addUnavailableVariable(String name) {
        this.unavailableVariables.add(name);
    }

    @Override
    public Object lookupVariable(String name) {
        if (this.unavailableVariables.contains(name)) {
            throw new VariableNotAvailableException(name);
        }
        Object variable = super.lookupVariable(name);
        if (variable != null) {
            return variable;
        }
        if (!this.paramLoaded) {
            this.loadArgsAsVariables();
            this.paramLoaded = true;
            variable = super.lookupVariable(name);
        }
        return variable;
    }

    private void loadArgsAsVariables() {
        if (ObjectUtils.isEmpty(this.args)) {
            return;
        }
        MethodCacheKey methodKey = new MethodCacheKey(this.method, this.targetClass);
        Method targetMethod = this.methodCache.get(methodKey);
        if (targetMethod == null) {
            targetMethod = AopUtils.getMostSpecificMethod(this.method, this.targetClass);
            if (targetMethod == null) {
                targetMethod = this.method;
            }
            this.methodCache.put(methodKey, targetMethod);
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.setVariable("a" + i, this.args[i]);
            this.setVariable("p" + i, this.args[i]);
        }
        String[] parameterNames = this.paramDiscoverer.getParameterNames(targetMethod);
        if (parameterNames != null) {
            for (int i = 0; i < parameterNames.length; ++i) {
                this.setVariable(parameterNames[i], this.args[i]);
            }
        }
    }
}

