/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.context.event;

import java.lang.reflect.Constructor;
import org.evosuite.shaded.org.aopalliance.intercept.MethodInterceptor;
import org.evosuite.shaded.org.aopalliance.intercept.MethodInvocation;
import org.evosuite.shaded.org.springframework.beans.factory.InitializingBean;
import org.evosuite.shaded.org.springframework.context.ApplicationEvent;
import org.evosuite.shaded.org.springframework.context.ApplicationEventPublisher;
import org.evosuite.shaded.org.springframework.context.ApplicationEventPublisherAware;

public class EventPublicationInterceptor
implements MethodInterceptor,
ApplicationEventPublisherAware,
InitializingBean {
    private Constructor<?> applicationEventClassConstructor;
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventClass(Class<?> applicationEventClass) {
        if (ApplicationEvent.class.equals(applicationEventClass) || !ApplicationEvent.class.isAssignableFrom(applicationEventClass)) {
            throw new IllegalArgumentException("applicationEventClass needs to extend ApplicationEvent");
        }
        try {
            this.applicationEventClassConstructor = applicationEventClass.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("applicationEventClass [" + applicationEventClass.getName() + "] does not have the required Object constructor: " + ex);
        }
    }

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.applicationEventClassConstructor == null) {
            throw new IllegalArgumentException("applicationEventClass is required");
        }
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retVal = invocation.proceed();
        ApplicationEvent event = (ApplicationEvent)this.applicationEventClassConstructor.newInstance(invocation.getThis());
        this.applicationEventPublisher.publishEvent(event);
        return retVal;
    }
}

