/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.context.expression;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.shaded.org.springframework.beans.BeansException;
import org.evosuite.shaded.org.springframework.beans.factory.BeanExpressionException;
import org.evosuite.shaded.org.springframework.beans.factory.config.BeanExpressionContext;
import org.evosuite.shaded.org.springframework.beans.factory.config.BeanExpressionResolver;
import org.evosuite.shaded.org.springframework.context.expression.BeanExpressionContextAccessor;
import org.evosuite.shaded.org.springframework.context.expression.BeanFactoryAccessor;
import org.evosuite.shaded.org.springframework.context.expression.BeanFactoryResolver;
import org.evosuite.shaded.org.springframework.context.expression.EnvironmentAccessor;
import org.evosuite.shaded.org.springframework.context.expression.MapAccessor;
import org.evosuite.shaded.org.springframework.core.convert.ConversionService;
import org.evosuite.shaded.org.springframework.expression.Expression;
import org.evosuite.shaded.org.springframework.expression.ExpressionParser;
import org.evosuite.shaded.org.springframework.expression.ParserContext;
import org.evosuite.shaded.org.springframework.expression.spel.SpelParserConfiguration;
import org.evosuite.shaded.org.springframework.expression.spel.standard.SpelExpressionParser;
import org.evosuite.shaded.org.springframework.expression.spel.support.StandardEvaluationContext;
import org.evosuite.shaded.org.springframework.expression.spel.support.StandardTypeConverter;
import org.evosuite.shaded.org.springframework.expression.spel.support.StandardTypeLocator;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.StringUtils;

public class StandardBeanExpressionResolver
implements BeanExpressionResolver {
    public static final String DEFAULT_EXPRESSION_PREFIX = "#{";
    public static final String DEFAULT_EXPRESSION_SUFFIX = "}";
    private String expressionPrefix = "#{";
    private String expressionSuffix = "}";
    private ExpressionParser expressionParser;
    private final Map<String, Expression> expressionCache = new ConcurrentHashMap<String, Expression>(256);
    private final Map<BeanExpressionContext, StandardEvaluationContext> evaluationCache = new ConcurrentHashMap<BeanExpressionContext, StandardEvaluationContext>(8);
    private final ParserContext beanExpressionParserContext = new ParserContext(){

        @Override
        public boolean isTemplate() {
            return true;
        }

        @Override
        public String getExpressionPrefix() {
            return StandardBeanExpressionResolver.this.expressionPrefix;
        }

        @Override
        public String getExpressionSuffix() {
            return StandardBeanExpressionResolver.this.expressionSuffix;
        }
    };

    public StandardBeanExpressionResolver() {
        this.expressionParser = new SpelExpressionParser();
    }

    public StandardBeanExpressionResolver(ClassLoader beanClassLoader) {
        this.expressionParser = new SpelExpressionParser(new SpelParserConfiguration(null, beanClassLoader));
    }

    public void setExpressionPrefix(String expressionPrefix) {
        Assert.hasText(expressionPrefix, "Expression prefix must not be empty");
        this.expressionPrefix = expressionPrefix;
    }

    public void setExpressionSuffix(String expressionSuffix) {
        Assert.hasText(expressionSuffix, "Expression suffix must not be empty");
        this.expressionSuffix = expressionSuffix;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull(expressionParser, "ExpressionParser must not be null");
        this.expressionParser = expressionParser;
    }

    @Override
    public Object evaluate(String value, BeanExpressionContext evalContext) throws BeansException {
        if (!StringUtils.hasLength(value)) {
            return value;
        }
        try {
            StandardEvaluationContext sec;
            Expression expr = this.expressionCache.get(value);
            if (expr == null) {
                expr = this.expressionParser.parseExpression(value, this.beanExpressionParserContext);
                this.expressionCache.put(value, expr);
            }
            if ((sec = this.evaluationCache.get(evalContext)) == null) {
                sec = new StandardEvaluationContext();
                sec.setRootObject(evalContext);
                sec.addPropertyAccessor(new BeanExpressionContextAccessor());
                sec.addPropertyAccessor(new BeanFactoryAccessor());
                sec.addPropertyAccessor(new MapAccessor());
                sec.addPropertyAccessor(new EnvironmentAccessor());
                sec.setBeanResolver(new BeanFactoryResolver(evalContext.getBeanFactory()));
                sec.setTypeLocator(new StandardTypeLocator(evalContext.getBeanFactory().getBeanClassLoader()));
                ConversionService conversionService = evalContext.getBeanFactory().getConversionService();
                if (conversionService != null) {
                    sec.setTypeConverter(new StandardTypeConverter(conversionService));
                }
                this.customizeEvaluationContext(sec);
                this.evaluationCache.put(evalContext, sec);
            }
            return expr.getValue(sec);
        }
        catch (Exception ex) {
            throw new BeanExpressionException("Expression parsing failed", ex);
        }
    }

    protected void customizeEvaluationContext(StandardEvaluationContext evalContext) {
    }
}

