/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.core.type;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.evosuite.shaded.org.springframework.core.annotation.AnnotatedElementUtils;
import org.evosuite.shaded.org.springframework.core.type.MethodMetadata;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.MultiValueMap;

public class StandardMethodMetadata
implements MethodMetadata {
    private final Method introspectedMethod;
    private final boolean nestedAnnotationsAsMap;

    public StandardMethodMetadata(Method introspectedMethod) {
        this(introspectedMethod, false);
    }

    public StandardMethodMetadata(Method introspectedMethod, boolean nestedAnnotationsAsMap) {
        Assert.notNull(introspectedMethod, "Method must not be null");
        this.introspectedMethod = introspectedMethod;
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    public final Method getIntrospectedMethod() {
        return this.introspectedMethod;
    }

    @Override
    public String getMethodName() {
        return this.introspectedMethod.getName();
    }

    @Override
    public String getDeclaringClassName() {
        return this.introspectedMethod.getDeclaringClass().getName();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isOverridable() {
        return !this.isStatic() && !this.isFinal() && !Modifier.isPrivate(this.introspectedMethod.getModifiers());
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        return AnnotatedElementUtils.isAnnotated(this.introspectedMethod, annotationType);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.getAnnotationAttributes(annotationType, false);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        return AnnotatedElementUtils.getAnnotationAttributes(this.introspectedMethod, annotationType, classValuesAsString, this.nestedAnnotationsAsMap);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationType) {
        return this.getAllAnnotationAttributes(annotationType, false);
    }

    @Override
    public MultiValueMap<String, Object> getAllAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        return AnnotatedElementUtils.getAllAnnotationAttributes(this.introspectedMethod, annotationType, classValuesAsString, this.nestedAnnotationsAsMap);
    }
}

