/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.expression.spel.ast;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.evosuite.shaded.org.springframework.asm.MethodVisitor;
import org.evosuite.shaded.org.springframework.core.convert.TypeDescriptor;
import org.evosuite.shaded.org.springframework.expression.AccessException;
import org.evosuite.shaded.org.springframework.expression.EvaluationContext;
import org.evosuite.shaded.org.springframework.expression.EvaluationException;
import org.evosuite.shaded.org.springframework.expression.ExpressionInvocationTargetException;
import org.evosuite.shaded.org.springframework.expression.MethodExecutor;
import org.evosuite.shaded.org.springframework.expression.MethodResolver;
import org.evosuite.shaded.org.springframework.expression.TypedValue;
import org.evosuite.shaded.org.springframework.expression.spel.CodeFlow;
import org.evosuite.shaded.org.springframework.expression.spel.ExpressionState;
import org.evosuite.shaded.org.springframework.expression.spel.SpelEvaluationException;
import org.evosuite.shaded.org.springframework.expression.spel.SpelMessage;
import org.evosuite.shaded.org.springframework.expression.spel.ast.FormatHelper;
import org.evosuite.shaded.org.springframework.expression.spel.ast.SpelNodeImpl;
import org.evosuite.shaded.org.springframework.expression.spel.ast.ValueRef;
import org.evosuite.shaded.org.springframework.expression.spel.support.ReflectiveMethodExecutor;
import org.evosuite.shaded.org.springframework.expression.spel.support.ReflectiveMethodResolver;

public class MethodReference
extends SpelNodeImpl {
    private final String name;
    private final boolean nullSafe;
    private volatile CachedMethodExecutor cachedExecutor;

    public MethodReference(boolean nullSafe, String methodName, int pos, SpelNodeImpl ... arguments) {
        super(pos, arguments);
        this.name = methodName;
        this.nullSafe = nullSafe;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        Object[] arguments = this.getArguments(state);
        if (state.getActiveContextObject().getValue() == null) {
            this.throwIfNotNullSafe(this.getArgumentTypes(arguments));
            return ValueRef.NullValueRef.INSTANCE;
        }
        return new MethodValueRef(state, arguments);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        EvaluationContext evaluationContext = state.getEvaluationContext();
        Object value = state.getActiveContextObject().getValue();
        TypeDescriptor targetType = state.getActiveContextObject().getTypeDescriptor();
        Object[] arguments = this.getArguments(state);
        TypedValue result = this.getValueInternal(evaluationContext, value, targetType, arguments);
        this.updateExitTypeDescriptor();
        return result;
    }

    private TypedValue getValueInternal(EvaluationContext evaluationContext, Object value, TypeDescriptor targetType, Object[] arguments) {
        List<TypeDescriptor> argumentTypes = this.getArgumentTypes(arguments);
        if (value == null) {
            this.throwIfNotNullSafe(argumentTypes);
            return TypedValue.NULL;
        }
        MethodExecutor executorToUse = this.getCachedExecutor(evaluationContext, value, targetType, argumentTypes);
        if (executorToUse != null) {
            try {
                return executorToUse.execute(evaluationContext, value, arguments);
            }
            catch (AccessException ex) {
                this.throwSimpleExceptionIfPossible(value, ex);
                this.cachedExecutor = null;
            }
        }
        executorToUse = this.findAccessorForMethod(this.name, argumentTypes, value, evaluationContext);
        this.cachedExecutor = new CachedMethodExecutor(executorToUse, value instanceof Class ? (Class)value : null, targetType, argumentTypes);
        try {
            return executorToUse.execute(evaluationContext, value, arguments);
        }
        catch (AccessException ex) {
            this.throwSimpleExceptionIfPossible(value, ex);
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_METHOD_INVOCATION, this.name, value.getClass().getName(), ex.getMessage());
        }
    }

    private void throwIfNotNullSafe(List<TypeDescriptor> argumentTypes) {
        if (!this.nullSafe) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_CALL_ON_NULL_OBJECT_NOT_ALLOWED, FormatHelper.formatMethodForMessage(this.name, argumentTypes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getArguments(ExpressionState state) {
        Object[] arguments = new Object[this.getChildCount()];
        for (int i = 0; i < arguments.length; ++i) {
            try {
                state.pushActiveContextObject(state.getRootContextObject());
                arguments[i] = this.children[i].getValueInternal(state).getValue();
                continue;
            }
            finally {
                state.popActiveContextObject();
            }
        }
        return arguments;
    }

    private List<TypeDescriptor> getArgumentTypes(Object ... arguments) {
        ArrayList<TypeDescriptor> descriptors = new ArrayList<TypeDescriptor>(arguments.length);
        for (Object argument : arguments) {
            descriptors.add(TypeDescriptor.forObject(argument));
        }
        return Collections.unmodifiableList(descriptors);
    }

    private MethodExecutor getCachedExecutor(EvaluationContext evaluationContext, Object value, TypeDescriptor target, List<TypeDescriptor> argumentTypes) {
        List<MethodResolver> methodResolvers = evaluationContext.getMethodResolvers();
        if (methodResolvers == null || methodResolvers.size() != 1 || !(methodResolvers.get(0) instanceof ReflectiveMethodResolver)) {
            return null;
        }
        CachedMethodExecutor executorToCheck = this.cachedExecutor;
        if (executorToCheck != null && executorToCheck.isSuitable(value, target, argumentTypes)) {
            return executorToCheck.get();
        }
        this.cachedExecutor = null;
        return null;
    }

    private MethodExecutor findAccessorForMethod(String name, List<TypeDescriptor> argumentTypes, Object targetObject, EvaluationContext evaluationContext) throws SpelEvaluationException {
        List<MethodResolver> methodResolvers = evaluationContext.getMethodResolvers();
        if (methodResolvers != null) {
            for (MethodResolver methodResolver : methodResolvers) {
                try {
                    MethodExecutor methodExecutor = methodResolver.resolve(evaluationContext, targetObject, name, argumentTypes);
                    if (methodExecutor == null) continue;
                    return methodExecutor;
                }
                catch (AccessException ex) {
                    throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.PROBLEM_LOCATING_METHOD, name, targetObject.getClass());
                }
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_NOT_FOUND, FormatHelper.formatMethodForMessage(name, argumentTypes), FormatHelper.formatClassNameForMessage(targetObject instanceof Class ? (Class<?>)targetObject : targetObject.getClass()));
    }

    private void throwSimpleExceptionIfPossible(Object value, AccessException ex) {
        if (ex.getCause() instanceof InvocationTargetException) {
            Throwable rootCause = ex.getCause().getCause();
            if (rootCause instanceof RuntimeException) {
                throw (RuntimeException)rootCause;
            }
            throw new ExpressionInvocationTargetException(this.getStartPosition(), "A problem occurred when trying to execute method '" + this.name + "' on object of type [" + value.getClass().getName() + "]", rootCause);
        }
    }

    private void updateExitTypeDescriptor() {
        CachedMethodExecutor executorToCheck = this.cachedExecutor;
        if (executorToCheck != null && executorToCheck.get() instanceof ReflectiveMethodExecutor) {
            Method method = ((ReflectiveMethodExecutor)executorToCheck.get()).getMethod();
            this.exitTypeDescriptor = CodeFlow.toDescriptor(method.getReturnType());
        }
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("(");
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getChild(i).toStringAST());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isCompilable() {
        CachedMethodExecutor executorToCheck = this.cachedExecutor;
        if (executorToCheck == null || !(executorToCheck.get() instanceof ReflectiveMethodExecutor)) {
            return false;
        }
        for (SpelNodeImpl child : this.children) {
            if (child.isCompilable()) continue;
            return false;
        }
        ReflectiveMethodExecutor executor = (ReflectiveMethodExecutor)executorToCheck.get();
        if (executor.didArgumentConversionOccur()) {
            return false;
        }
        Method method = executor.getMethod();
        Class<?> clazz = method.getDeclaringClass();
        return Modifier.isPublic(clazz.getModifiers()) || executor.getPublicDeclaringClass() != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        CachedMethodExecutor executorToCheck = this.cachedExecutor;
        if (executorToCheck == null || !(executorToCheck.get() instanceof ReflectiveMethodExecutor)) {
            throw new IllegalStateException("No applicable cached executor found: " + executorToCheck);
        }
        ReflectiveMethodExecutor methodExecutor = (ReflectiveMethodExecutor)executorToCheck.get();
        Method method = methodExecutor.getMethod();
        boolean isStaticMethod = Modifier.isStatic(method.getModifiers());
        String descriptor = cf.lastDescriptor();
        if (descriptor == null && !isStaticMethod) {
            cf.loadTarget(mv);
        }
        if (CodeFlow.isPrimitive(descriptor)) {
            CodeFlow.insertBoxIfNecessary(mv, descriptor.charAt(0));
        }
        boolean itf = method.getDeclaringClass().isInterface();
        String methodDeclaringClassSlashedDescriptor = null;
        methodDeclaringClassSlashedDescriptor = Modifier.isPublic(method.getDeclaringClass().getModifiers()) ? method.getDeclaringClass().getName().replace('.', '/') : methodExecutor.getPublicDeclaringClass().getName().replace('.', '/');
        if (!(isStaticMethod || descriptor != null && descriptor.substring(1).equals(methodDeclaringClassSlashedDescriptor))) {
            CodeFlow.insertCheckCast(mv, "L" + methodDeclaringClassSlashedDescriptor);
        }
        MethodReference.generateCodeForArguments(mv, cf, method, this.children);
        mv.visitMethodInsn(isStaticMethod ? 184 : 182, methodDeclaringClassSlashedDescriptor, method.getName(), CodeFlow.createSignatureDescriptor(method), itf);
        cf.pushDescriptor(this.exitTypeDescriptor);
    }

    private static class CachedMethodExecutor {
        private final MethodExecutor methodExecutor;
        private final Class<?> staticClass;
        private final TypeDescriptor target;
        private final List<TypeDescriptor> argumentTypes;

        public CachedMethodExecutor(MethodExecutor methodExecutor, Class<?> staticClass, TypeDescriptor target, List<TypeDescriptor> argumentTypes) {
            this.methodExecutor = methodExecutor;
            this.staticClass = staticClass;
            this.target = target;
            this.argumentTypes = argumentTypes;
        }

        public boolean isSuitable(Object value, TypeDescriptor target, List<TypeDescriptor> argumentTypes) {
            return (this.staticClass == null || this.staticClass.equals(value)) && this.target.equals(target) && this.argumentTypes.equals(argumentTypes);
        }

        public MethodExecutor get() {
            return this.methodExecutor;
        }
    }

    private class MethodValueRef
    implements ValueRef {
        private final EvaluationContext evaluationContext;
        private final Object value;
        private final TypeDescriptor targetType;
        private final Object[] arguments;

        public MethodValueRef(ExpressionState state, Object[] arguments) {
            this.evaluationContext = state.getEvaluationContext();
            this.value = state.getActiveContextObject().getValue();
            this.targetType = state.getActiveContextObject().getTypeDescriptor();
            this.arguments = arguments;
        }

        @Override
        public TypedValue getValue() {
            TypedValue result = MethodReference.this.getValueInternal(this.evaluationContext, this.value, this.targetType, this.arguments);
            MethodReference.this.updateExitTypeDescriptor();
            return result;
        }

        @Override
        public void setValue(Object newValue) {
            throw new IllegalAccessError();
        }

        @Override
        public boolean isWritable() {
            return false;
        }
    }
}

