/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.evosuite.shaded.org.springframework.expression.EvaluationException;
import org.evosuite.shaded.org.springframework.expression.TypedValue;
import org.evosuite.shaded.org.springframework.expression.spel.ExpressionState;
import org.evosuite.shaded.org.springframework.expression.spel.SpelEvaluationException;
import org.evosuite.shaded.org.springframework.expression.spel.SpelMessage;
import org.evosuite.shaded.org.springframework.expression.spel.ast.SpelNodeImpl;
import org.evosuite.shaded.org.springframework.expression.spel.ast.ValueRef;
import org.evosuite.shaded.org.springframework.util.ClassUtils;
import org.evosuite.shaded.org.springframework.util.ObjectUtils;

public class Projection
extends SpelNodeImpl {
    private final boolean nullSafe;

    public Projection(boolean nullSafe, int pos, SpelNodeImpl expression) {
        super(pos, expression);
        this.nullSafe = nullSafe;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        return this.getValueRef(state).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        TypedValue op = state.getActiveContextObject();
        Object operand = op.getValue();
        boolean operandIsArray = ObjectUtils.isArray(operand);
        if (operand instanceof Map) {
            Map mapData = (Map)operand;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Map.Entry entry : mapData.entrySet()) {
                try {
                    state.pushActiveContextObject(new TypedValue(entry));
                    result.add(this.children[0].getValueInternal(state).getValue());
                }
                finally {
                    state.popActiveContextObject();
                }
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(result), this);
        }
        if (operand instanceof Collection || operandIsArray) {
            List<Object> data = operand instanceof Collection ? (List<Object>)operand : Arrays.asList(ObjectUtils.toObjectArray(operand));
            ArrayList<Object> result = new ArrayList<Object>();
            int idx = 0;
            Class arrayElementType = null;
            for (Object e : data) {
                try {
                    state.pushActiveContextObject(new TypedValue(e));
                    state.enterScope("index", idx);
                    Object value = this.children[0].getValueInternal(state).getValue();
                    if (value != null && operandIsArray) {
                        arrayElementType = this.determineCommonType(arrayElementType, value.getClass());
                    }
                    result.add(value);
                }
                finally {
                    state.exitScope();
                    state.popActiveContextObject();
                }
                ++idx;
            }
            if (operandIsArray) {
                if (arrayElementType == null) {
                    arrayElementType = Object.class;
                }
                Object resultArray = Array.newInstance(arrayElementType, result.size());
                System.arraycopy(result.toArray(), 0, resultArray, 0, result.size());
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(resultArray), this);
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(result), this);
        }
        if (operand == null) {
            if (this.nullSafe) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, operand.getClass().getName());
    }

    @Override
    public String toStringAST() {
        return "![" + this.getChild(0).toStringAST() + "]";
    }

    private Class<?> determineCommonType(Class<?> oldType, Class<?> newType) {
        Class<?>[] interfaces;
        if (oldType == null) {
            return newType;
        }
        if (oldType.isAssignableFrom(newType)) {
            return oldType;
        }
        for (Class<?> nextType = newType; nextType != Object.class; nextType = nextType.getSuperclass()) {
            if (!nextType.isAssignableFrom(oldType)) continue;
            return nextType;
        }
        for (Class<?> nextInterface : interfaces = ClassUtils.getAllInterfacesForClass(newType)) {
            if (!nextInterface.isAssignableFrom(oldType)) continue;
            return nextInterface;
        }
        return Object.class;
    }
}

