/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.format.datetime.joda;

import java.util.Locale;
import org.evosuite.shaded.org.springframework.core.NamedThreadLocal;
import org.evosuite.shaded.org.springframework.format.datetime.joda.JodaTimeContext;
import org.joda.time.format.DateTimeFormatter;

public final class JodaTimeContextHolder {
    private static final ThreadLocal<JodaTimeContext> jodaTimeContextHolder = new NamedThreadLocal<JodaTimeContext>("JodaTime Context");

    public static void resetJodaTimeContext() {
        jodaTimeContextHolder.remove();
    }

    public static void setJodaTimeContext(JodaTimeContext jodaTimeContext) {
        if (jodaTimeContext == null) {
            JodaTimeContextHolder.resetJodaTimeContext();
        } else {
            jodaTimeContextHolder.set(jodaTimeContext);
        }
    }

    public static JodaTimeContext getJodaTimeContext() {
        return jodaTimeContextHolder.get();
    }

    public static DateTimeFormatter getFormatter(DateTimeFormatter formatter, Locale locale) {
        DateTimeFormatter formatterToUse = locale != null ? formatter.withLocale(locale) : formatter;
        JodaTimeContext context = JodaTimeContextHolder.getJodaTimeContext();
        return context != null ? context.getFormatter(formatterToUse) : formatterToUse;
    }
}

