/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.format.datetime.standard;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.shaded.org.springframework.context.support.EmbeddedValueResolutionSupport;
import org.evosuite.shaded.org.springframework.format.AnnotationFormatterFactory;
import org.evosuite.shaded.org.springframework.format.Parser;
import org.evosuite.shaded.org.springframework.format.Printer;
import org.evosuite.shaded.org.springframework.format.annotation.DateTimeFormat;
import org.evosuite.shaded.org.springframework.format.datetime.standard.DateTimeFormatterFactory;
import org.evosuite.shaded.org.springframework.format.datetime.standard.TemporalAccessorParser;
import org.evosuite.shaded.org.springframework.format.datetime.standard.TemporalAccessorPrinter;

public class Jsr310DateTimeFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<DateTimeFormat> {
    private static final Set<Class<?>> FIELD_TYPES;

    @Override
    public final Set<Class<?>> getFieldTypes() {
        return FIELD_TYPES;
    }

    @Override
    public Printer<?> getPrinter(DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatter formatter = this.getFormatter(annotation, fieldType);
        return new TemporalAccessorPrinter(formatter);
    }

    @Override
    public Parser<?> getParser(DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatter formatter = this.getFormatter(annotation, fieldType);
        return new TemporalAccessorParser(fieldType, formatter);
    }

    protected DateTimeFormatter getFormatter(DateTimeFormat annotation, Class<?> fieldType) {
        DateTimeFormatterFactory factory = new DateTimeFormatterFactory();
        factory.setStylePattern(this.resolveEmbeddedValue(annotation.style()));
        factory.setIso(annotation.iso());
        factory.setPattern(this.resolveEmbeddedValue(annotation.pattern()));
        return factory.createDateTimeFormatter();
    }

    static {
        HashSet<Class> fieldTypes = new HashSet<Class>(8);
        fieldTypes.add(LocalDate.class);
        fieldTypes.add(LocalTime.class);
        fieldTypes.add(LocalDateTime.class);
        fieldTypes.add(ZonedDateTime.class);
        fieldTypes.add(OffsetDateTime.class);
        fieldTypes.add(OffsetTime.class);
        FIELD_TYPES = Collections.unmodifiableSet(fieldTypes);
    }
}

