/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.config;

import org.evosuite.shaded.org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.evosuite.shaded.org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.evosuite.shaded.org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.evosuite.shaded.org.springframework.beans.factory.xml.ParserContext;
import org.evosuite.shaded.org.springframework.jdbc.config.DatabasePopulatorConfigUtils;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactoryBean;
import org.evosuite.shaded.org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class EmbeddedDatabaseBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    EmbeddedDatabaseBeanDefinitionParser() {
    }

    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(EmbeddedDatabaseFactoryBean.class);
        this.setDatabaseType(element, builder);
        DatabasePopulatorConfigUtils.setDatabasePopulator(element, builder);
        this.useIdAsDatabaseNameIfGiven(element, builder);
        builder.getRawBeanDefinition().setSource(parserContext.extractSource(element));
        return builder.getBeanDefinition();
    }

    private void useIdAsDatabaseNameIfGiven(Element element, BeanDefinitionBuilder builder) {
        String id = element.getAttribute("id");
        if (StringUtils.hasText(id)) {
            builder.addPropertyValue("databaseName", id);
        }
    }

    private void setDatabaseType(Element element, BeanDefinitionBuilder builder) {
        String type = element.getAttribute("type");
        if (StringUtils.hasText(type)) {
            builder.addPropertyValue("databaseType", type);
        }
    }
}

