/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.evosuite.shaded.org.springframework.jdbc.core.metadata.GenericCallMetaDataProvider;

public class Db2CallMetaDataProvider
extends GenericCallMetaDataProvider {
    public Db2CallMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        super(databaseMetaData);
    }

    @Override
    public void initializeWithMetaData(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            this.setSupportsCatalogsInProcedureCalls(databaseMetaData.supportsCatalogsInProcedureCalls());
        }
        catch (SQLException se) {
            logger.debug("Error retrieving 'DatabaseMetaData.supportsCatalogsInProcedureCalls' - " + se.getMessage());
        }
        try {
            this.setSupportsSchemasInProcedureCalls(databaseMetaData.supportsSchemasInProcedureCalls());
        }
        catch (SQLException se) {
            logger.debug("Error retrieving 'DatabaseMetaData.supportsSchemasInProcedureCalls' - " + se.getMessage());
        }
        try {
            this.setStoresUpperCaseIdentifiers(databaseMetaData.storesUpperCaseIdentifiers());
        }
        catch (SQLException se) {
            logger.debug("Error retrieving 'DatabaseMetaData.storesUpperCaseIdentifiers' - " + se.getMessage());
        }
        try {
            this.setStoresLowerCaseIdentifiers(databaseMetaData.storesLowerCaseIdentifiers());
        }
        catch (SQLException se) {
            logger.debug("Error retrieving 'DatabaseMetaData.storesLowerCaseIdentifiers' - " + se.getMessage());
        }
    }

    @Override
    public String metaDataSchemaNameToUse(String schemaName) {
        if (schemaName != null) {
            return super.metaDataSchemaNameToUse(schemaName);
        }
        String userName = this.getUserName();
        return userName != null ? userName.toUpperCase() : null;
    }
}

