/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.core.namedparam;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.evosuite.shaded.org.springframework.jdbc.core.SqlParameterValue;
import org.evosuite.shaded.org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.evosuite.shaded.org.springframework.util.Assert;

public class MapSqlParameterSource
extends AbstractSqlParameterSource {
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();

    public MapSqlParameterSource() {
    }

    public MapSqlParameterSource(String paramName, Object value) {
        this.addValue(paramName, value);
    }

    public MapSqlParameterSource(Map<String, ?> values) {
        this.addValues(values);
    }

    public MapSqlParameterSource addValue(String paramName, Object value) {
        Assert.notNull(paramName, "Parameter name must not be null");
        this.values.put(paramName, value);
        if (value instanceof SqlParameterValue) {
            this.registerSqlType(paramName, ((SqlParameterValue)value).getSqlType());
        }
        return this;
    }

    public MapSqlParameterSource addValue(String paramName, Object value, int sqlType) {
        Assert.notNull(paramName, "Parameter name must not be null");
        this.values.put(paramName, value);
        this.registerSqlType(paramName, sqlType);
        return this;
    }

    public MapSqlParameterSource addValue(String paramName, Object value, int sqlType, String typeName) {
        Assert.notNull(paramName, "Parameter name must not be null");
        this.values.put(paramName, value);
        this.registerSqlType(paramName, sqlType);
        this.registerTypeName(paramName, typeName);
        return this;
    }

    public MapSqlParameterSource addValues(Map<String, ?> values) {
        if (values != null) {
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                this.values.put(entry.getKey(), entry.getValue());
                if (!(entry.getValue() instanceof SqlParameterValue)) continue;
                SqlParameterValue value = (SqlParameterValue)entry.getValue();
                this.registerSqlType(entry.getKey(), value.getSqlType());
            }
        }
        return this;
    }

    public Map<String, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public boolean hasValue(String paramName) {
        return this.values.containsKey(paramName);
    }

    @Override
    public Object getValue(String paramName) {
        if (!this.hasValue(paramName)) {
            throw new IllegalArgumentException("No value registered for key '" + paramName + "'");
        }
        return this.values.get(paramName);
    }
}

