/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import org.evosuite.shaded.org.springframework.core.Constants;
import org.evosuite.shaded.org.springframework.jdbc.datasource.UserCredentialsDataSourceAdapter;
import org.evosuite.shaded.org.springframework.transaction.TransactionDefinition;
import org.evosuite.shaded.org.springframework.transaction.support.TransactionSynchronizationManager;

public class IsolationLevelDataSourceAdapter
extends UserCredentialsDataSourceAdapter {
    private static final Constants constants = new Constants(TransactionDefinition.class);
    private Integer isolationLevel;

    public final void setIsolationLevelName(String constantName) throws IllegalArgumentException {
        if (constantName == null || !constantName.startsWith("ISOLATION_")) {
            throw new IllegalArgumentException("Only isolation constants allowed");
        }
        this.setIsolationLevel(constants.asNumber(constantName).intValue());
    }

    public void setIsolationLevel(int isolationLevel) {
        if (!constants.getValues("ISOLATION_").contains(isolationLevel)) {
            throw new IllegalArgumentException("Only values of isolation constants allowed");
        }
        this.isolationLevel = isolationLevel != -1 ? Integer.valueOf(isolationLevel) : null;
    }

    protected Integer getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    protected Connection doGetConnection(String username, String password) throws SQLException {
        Integer isolationLevelToUse;
        Connection con = super.doGetConnection(username, password);
        Boolean readOnlyToUse = this.getCurrentReadOnlyFlag();
        if (readOnlyToUse != null) {
            con.setReadOnly(readOnlyToUse);
        }
        if ((isolationLevelToUse = this.getCurrentIsolationLevel()) != null) {
            con.setTransactionIsolation(isolationLevelToUse);
        }
        return con;
    }

    protected Integer getCurrentIsolationLevel() {
        Integer isolationLevelToUse = TransactionSynchronizationManager.getCurrentTransactionIsolationLevel();
        if (isolationLevelToUse == null) {
            isolationLevelToUse = this.getIsolationLevel();
        }
        return isolationLevelToUse;
    }

    protected Boolean getCurrentReadOnlyFlag() {
        boolean txReadOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
        return txReadOnly ? Boolean.TRUE : null;
    }
}

