/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.datasource.embedded;

import javax.sql.DataSource;
import org.evosuite.shaded.org.springframework.beans.factory.DisposableBean;
import org.evosuite.shaded.org.springframework.beans.factory.FactoryBean;
import org.evosuite.shaded.org.springframework.beans.factory.InitializingBean;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseFactory;
import org.evosuite.shaded.org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.evosuite.shaded.org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;

public class EmbeddedDatabaseFactoryBean
extends EmbeddedDatabaseFactory
implements FactoryBean<DataSource>,
InitializingBean,
DisposableBean {
    private DatabasePopulator databaseCleaner;

    public void setDatabaseCleaner(DatabasePopulator databaseCleaner) {
        this.databaseCleaner = databaseCleaner;
    }

    @Override
    public void afterPropertiesSet() {
        this.initDatabase();
    }

    @Override
    public DataSource getObject() {
        return this.getDataSource();
    }

    @Override
    public Class<? extends DataSource> getObjectType() {
        return DataSource.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void destroy() {
        if (this.databaseCleaner != null) {
            DatabasePopulatorUtils.execute(this.databaseCleaner, this.getDataSource());
        }
        this.shutdownDatabase();
    }
}

