/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.datasource.init;

import java.sql.Connection;
import javax.sql.DataSource;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.jdbc.datasource.DataSourceUtils;
import org.evosuite.shaded.org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.evosuite.shaded.org.springframework.jdbc.datasource.init.ScriptException;
import org.evosuite.shaded.org.springframework.jdbc.datasource.init.UncategorizedScriptException;
import org.evosuite.shaded.org.springframework.util.Assert;

public abstract class DatabasePopulatorUtils {
    public static void execute(DatabasePopulator populator, DataSource dataSource) throws DataAccessException {
        Assert.notNull(populator, "DatabasePopulator must be provided");
        Assert.notNull(dataSource, "DataSource must be provided");
        try {
            Connection connection = DataSourceUtils.getConnection(dataSource);
            try {
                populator.populate(connection);
            }
            finally {
                if (connection != null) {
                    DataSourceUtils.releaseConnection(connection, dataSource);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof ScriptException) {
                throw (ScriptException)ex;
            }
            throw new UncategorizedScriptException("Failed to execute database script", ex);
        }
    }
}

