/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.object;

import java.util.Map;
import org.evosuite.shaded.org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.evosuite.shaded.org.springframework.jdbc.core.RowMapper;
import org.evosuite.shaded.org.springframework.jdbc.object.SqlQuery;
import org.evosuite.shaded.org.springframework.util.Assert;

public class GenericSqlQuery<T>
extends SqlQuery<T> {
    Class<?> rowMapperClass;
    RowMapper<?> rowMapper;

    public void setRowMapperClass(Class<? extends RowMapper> rowMapperClass) throws IllegalAccessException, InstantiationException {
        this.rowMapperClass = rowMapperClass;
        if (!RowMapper.class.isAssignableFrom(rowMapperClass)) {
            throw new IllegalStateException("The specified class '" + rowMapperClass.getName() + " is not a sub class of " + "'org.springframework.jdbc.core.RowMapper'");
        }
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull(this.rowMapperClass, "The 'rowMapperClass' property is required");
    }

    @Override
    protected RowMapper<T> newRowMapper(Object[] parameters, Map<?, ?> context) {
        try {
            return (RowMapper)this.rowMapperClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new InvalidDataAccessResourceUsageException("Unable to instantiate RowMapper", e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidDataAccessResourceUsageException("Unable to instantiate RowMapper", e);
        }
    }
}

