/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.support;

import java.sql.SQLException;
import org.evosuite.shaded.org.apache.commons.logging.Log;
import org.evosuite.shaded.org.apache.commons.logging.LogFactory;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.jdbc.UncategorizedSQLException;
import org.evosuite.shaded.org.springframework.jdbc.support.SQLExceptionTranslator;
import org.evosuite.shaded.org.springframework.util.Assert;

public abstract class AbstractFallbackSQLExceptionTranslator
implements SQLExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SQLExceptionTranslator fallbackTranslator;

    public void setFallbackTranslator(SQLExceptionTranslator fallback) {
        this.fallbackTranslator = fallback;
    }

    public SQLExceptionTranslator getFallbackTranslator() {
        return this.fallbackTranslator;
    }

    @Override
    public DataAccessException translate(String task, String sql, SQLException ex) {
        DataAccessException dex;
        Assert.notNull(ex, "Cannot translate a null SQLException");
        if (task == null) {
            task = "";
        }
        if (sql == null) {
            sql = "";
        }
        if ((dex = this.doTranslate(task, sql, ex)) != null) {
            return dex;
        }
        SQLExceptionTranslator fallback = this.getFallbackTranslator();
        if (fallback != null) {
            return fallback.translate(task, sql, ex);
        }
        return new UncategorizedSQLException(task, sql, ex);
    }

    protected abstract DataAccessException doTranslate(String var1, String var2, SQLException var3);

    protected String buildMessage(String task, String sql, SQLException ex) {
        return task + "; SQL [" + sql + "]; " + ex.getMessage();
    }
}

