/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.evosuite.shaded.org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.evosuite.shaded.org.springframework.util.ReflectionUtils;

public class WebLogicNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JDBC_EXTENSION_NAME = "weblogic.jdbc.extensions.WLConnection";
    private final Class<?> jdbcExtensionClass;
    private final Method getVendorConnectionMethod;

    public WebLogicNativeJdbcExtractor() {
        try {
            this.jdbcExtensionClass = this.getClass().getClassLoader().loadClass(JDBC_EXTENSION_NAME);
            this.getVendorConnectionMethod = this.jdbcExtensionClass.getMethod("getVendorConnection", null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize WebLogicNativeJdbcExtractor because WebLogic API classes are not available: " + ex);
        }
    }

    @Override
    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    @Override
    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    @Override
    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    @Override
    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.jdbcExtensionClass.isAssignableFrom(con.getClass())) {
            return (Connection)ReflectionUtils.invokeJdbcMethod(this.getVendorConnectionMethod, con);
        }
        return con;
    }
}

