/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate3;

import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.JDBCException;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.support.PersistenceExceptionTranslator;
import org.evosuite.shaded.org.springframework.jdbc.support.SQLExceptionTranslator;
import org.evosuite.shaded.org.springframework.orm.hibernate3.SessionFactoryUtils;

public class HibernateExceptionTranslator
implements PersistenceExceptionTranslator {
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    @Override
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex);
        }
        return null;
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (this.jdbcExceptionTranslator != null && ex instanceof JDBCException) {
            JDBCException jdbcEx = (JDBCException)ex;
            return this.jdbcExceptionTranslator.translate("Hibernate operation: " + jdbcEx.getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException());
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }
}

