/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate3.support;

import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.Session;
import org.evosuite.shaded.org.hibernate.SessionFactory;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.DataAccessResourceFailureException;
import org.evosuite.shaded.org.springframework.dao.support.DaoSupport;
import org.evosuite.shaded.org.springframework.orm.hibernate3.HibernateTemplate;
import org.evosuite.shaded.org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class HibernateDaoSupport
extends DaoSupport {
    private HibernateTemplate hibernateTemplate;

    public final void setSessionFactory(SessionFactory sessionFactory) {
        if (this.hibernateTemplate == null || sessionFactory != this.hibernateTemplate.getSessionFactory()) {
            this.hibernateTemplate = this.createHibernateTemplate(sessionFactory);
        }
    }

    protected HibernateTemplate createHibernateTemplate(SessionFactory sessionFactory) {
        return new HibernateTemplate(sessionFactory);
    }

    public final SessionFactory getSessionFactory() {
        return this.hibernateTemplate != null ? this.hibernateTemplate.getSessionFactory() : null;
    }

    public final void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public final HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    @Override
    protected final void checkDaoConfig() {
        if (this.hibernateTemplate == null) {
            throw new IllegalArgumentException("'sessionFactory' or 'hibernateTemplate' is required");
        }
    }

    @Deprecated
    protected final Session getSession() throws DataAccessResourceFailureException, IllegalStateException {
        return this.getSession(this.hibernateTemplate.isAllowCreate());
    }

    @Deprecated
    protected final Session getSession(boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return !allowCreate ? SessionFactoryUtils.getSession(this.getSessionFactory(), false) : SessionFactoryUtils.getSession(this.getSessionFactory(), this.hibernateTemplate.getEntityInterceptor(), this.hibernateTemplate.getJdbcExceptionTranslator());
    }

    @Deprecated
    protected final DataAccessException convertHibernateAccessException(HibernateException ex) {
        return this.hibernateTemplate.convertHibernateAccessException(ex);
    }

    @Deprecated
    protected final void releaseSession(Session session) {
        SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
    }
}

