/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate3.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.evosuite.shaded.org.hibernate.FlushMode;
import org.evosuite.shaded.org.hibernate.Session;
import org.evosuite.shaded.org.hibernate.SessionFactory;
import org.evosuite.shaded.org.springframework.dao.DataAccessResourceFailureException;
import org.evosuite.shaded.org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.evosuite.shaded.org.springframework.orm.hibernate3.SessionHolder;
import org.evosuite.shaded.org.springframework.orm.hibernate3.support.AsyncRequestInterceptor;
import org.evosuite.shaded.org.springframework.transaction.support.TransactionSynchronizationManager;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.web.context.WebApplicationContext;
import org.evosuite.shaded.org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.async.WebAsyncManager;
import org.evosuite.shaded.org.springframework.web.context.request.async.WebAsyncUtils;
import org.evosuite.shaded.org.springframework.web.context.support.WebApplicationContextUtils;
import org.evosuite.shaded.org.springframework.web.filter.OncePerRequestFilter;

public class OpenSessionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";
    private boolean singleSession = true;
    private FlushMode flushMode = FlushMode.MANUAL;

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected String getSessionFactoryBeanName() {
        return this.sessionFactoryBeanName;
    }

    public void setSingleSession(boolean singleSession) {
        this.singleSession = singleSession;
    }

    protected boolean isSingleSession() {
        return this.singleSession;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    protected FlushMode getFlushMode() {
        return this.flushMode;
    }

    protected boolean shouldNotFilterAsyncDispatch() {
        return false;
    }

    protected boolean shouldNotFilterErrorDispatch() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionFactory sessionFactory = this.lookupSessionFactory(request);
        boolean participate = false;
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((ServletRequest)request);
        String key = this.getAlreadyFilteredAttributeName();
        if (this.isSingleSession()) {
            if (TransactionSynchronizationManager.hasResource(sessionFactory)) {
                participate = true;
            } else {
                boolean isFirstRequest;
                boolean bl = isFirstRequest = !this.isAsyncDispatch(request);
                if (isFirstRequest || !this.applySessionBindingInterceptor(asyncManager, key)) {
                    this.logger.debug("Opening single Hibernate Session in OpenSessionInViewFilter");
                    Session session = this.getSession(sessionFactory);
                    SessionHolder sessionHolder = new SessionHolder(session);
                    TransactionSynchronizationManager.bindResource(sessionFactory, sessionHolder);
                    AsyncRequestInterceptor interceptor = new AsyncRequestInterceptor(sessionFactory, sessionHolder);
                    asyncManager.registerCallableInterceptor((Object)key, (CallableProcessingInterceptor)interceptor);
                    asyncManager.registerDeferredResultInterceptor((Object)key, (DeferredResultProcessingInterceptor)interceptor);
                }
            }
        } else {
            Assert.state(!this.isAsyncStarted(request), "Deferred close mode is not supported on async dispatches");
            if (SessionFactoryUtils.isDeferredCloseActive(sessionFactory)) {
                participate = true;
            } else {
                SessionFactoryUtils.initDeferredClose(sessionFactory);
            }
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (!participate) {
                if (this.isSingleSession()) {
                    SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(sessionFactory);
                    if (!this.isAsyncStarted(request)) {
                        this.logger.debug("Closing single Hibernate Session in OpenSessionInViewFilter");
                        this.closeSession(sessionHolder.getSession(), sessionFactory);
                    }
                } else {
                    SessionFactoryUtils.processDeferredClose(sessionFactory);
                }
            }
        }
    }

    protected SessionFactory lookupSessionFactory(HttpServletRequest request) {
        return this.lookupSessionFactory();
    }

    protected SessionFactory lookupSessionFactory() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using SessionFactory '" + this.getSessionFactoryBeanName() + "' for OpenSessionInViewFilter");
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (SessionFactory)wac.getBean(this.getSessionFactoryBeanName(), SessionFactory.class);
    }

    protected Session getSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession(sessionFactory, true);
        FlushMode flushMode = this.getFlushMode();
        if (flushMode != null) {
            session.setFlushMode(flushMode);
        }
        return session;
    }

    protected void closeSession(Session session, SessionFactory sessionFactory) {
        SessionFactoryUtils.closeSession(session);
    }

    private boolean applySessionBindingInterceptor(WebAsyncManager asyncManager, String key) {
        if (asyncManager.getCallableInterceptor((Object)key) == null) {
            return false;
        }
        ((AsyncRequestInterceptor)asyncManager.getCallableInterceptor((Object)key)).bindSession();
        return true;
    }
}

