/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jpa;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.evosuite.shaded.org.apache.commons.logging.Log;
import org.evosuite.shaded.org.apache.commons.logging.LogFactory;
import org.evosuite.shaded.org.springframework.beans.BeanUtils;
import org.evosuite.shaded.org.springframework.beans.factory.BeanClassLoaderAware;
import org.evosuite.shaded.org.springframework.beans.factory.BeanFactory;
import org.evosuite.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.evosuite.shaded.org.springframework.beans.factory.BeanNameAware;
import org.evosuite.shaded.org.springframework.beans.factory.DisposableBean;
import org.evosuite.shaded.org.springframework.beans.factory.FactoryBean;
import org.evosuite.shaded.org.springframework.beans.factory.InitializingBean;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.support.PersistenceExceptionTranslator;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.evosuite.shaded.org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import org.evosuite.shaded.org.springframework.orm.jpa.JpaDialect;
import org.evosuite.shaded.org.springframework.orm.jpa.JpaVendorAdapter;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.ClassUtils;
import org.evosuite.shaded.org.springframework.util.CollectionUtils;

public abstract class AbstractEntityManagerFactoryBean
implements FactoryBean<EntityManagerFactory>,
BeanClassLoaderAware,
BeanFactoryAware,
BeanNameAware,
InitializingBean,
DisposableBean,
EntityManagerFactoryInfo,
PersistenceExceptionTranslator,
Serializable {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PersistenceProvider persistenceProvider;
    private String persistenceUnitName;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();
    private Class<? extends EntityManagerFactory> entityManagerFactoryInterface;
    private Class<? extends EntityManager> entityManagerInterface;
    private JpaDialect jpaDialect;
    private JpaVendorAdapter jpaVendorAdapter;
    private ClassLoader beanClassLoader = this.getClass().getClassLoader();
    private BeanFactory beanFactory;
    private String beanName;
    public EntityManagerFactory nativeEntityManagerFactory;
    private EntityManagerFactory entityManagerFactory;

    public void setPersistenceProviderClass(Class<? extends PersistenceProvider> persistenceProviderClass) {
        Assert.isAssignable(PersistenceProvider.class, persistenceProviderClass);
        this.persistenceProvider = BeanUtils.instantiateClass(persistenceProviderClass);
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    @Override
    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    @Override
    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setJpaProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap(jpaProperties, this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(Map<String, ?> jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setEntityManagerFactoryInterface(Class<? extends EntityManagerFactory> emfInterface) {
        Assert.isAssignable(EntityManagerFactory.class, emfInterface);
        this.entityManagerFactoryInterface = emfInterface;
    }

    public void setEntityManagerInterface(Class<? extends EntityManager> emInterface) {
        Assert.isAssignable(EntityManager.class, emInterface);
        this.entityManagerInterface = emInterface;
    }

    @Override
    public Class<? extends EntityManager> getEntityManagerInterface() {
        return this.entityManagerInterface;
    }

    public void setJpaDialect(JpaDialect jpaDialect) {
        this.jpaDialect = jpaDialect;
    }

    @Override
    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public void setJpaVendorAdapter(JpaVendorAdapter jpaVendorAdapter) {
        this.jpaVendorAdapter = jpaVendorAdapter;
    }

    public JpaVendorAdapter getJpaVendorAdapter() {
        return this.jpaVendorAdapter;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public final void afterPropertiesSet() throws PersistenceException {
        if (this.jpaVendorAdapter != null) {
            Map<String, ?> vendorPropertyMap;
            if (this.persistenceProvider == null) {
                this.persistenceProvider = this.jpaVendorAdapter.getPersistenceProvider();
            }
            if ((vendorPropertyMap = this.jpaVendorAdapter.getJpaPropertyMap()) != null) {
                for (Map.Entry<String, ?> entry : vendorPropertyMap.entrySet()) {
                    if (this.jpaPropertyMap.containsKey(entry.getKey())) continue;
                    this.jpaPropertyMap.put(entry.getKey(), entry.getValue());
                }
            }
            if (this.entityManagerFactoryInterface == null) {
                this.entityManagerFactoryInterface = this.jpaVendorAdapter.getEntityManagerFactoryInterface();
                if (!ClassUtils.isVisible(this.entityManagerFactoryInterface, this.beanClassLoader)) {
                    this.entityManagerFactoryInterface = EntityManagerFactory.class;
                }
            }
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = this.jpaVendorAdapter.getEntityManagerInterface();
                if (!ClassUtils.isVisible(this.entityManagerInterface, this.beanClassLoader)) {
                    this.entityManagerInterface = EntityManager.class;
                }
            }
            if (this.jpaDialect == null) {
                this.jpaDialect = this.jpaVendorAdapter.getJpaDialect();
            }
        }
        this.nativeEntityManagerFactory = this.createNativeEntityManagerFactory();
        if (this.nativeEntityManagerFactory == null) {
            throw new IllegalStateException("JPA PersistenceProvider returned null EntityManagerFactory - check your JPA provider setup!");
        }
        if (this.jpaVendorAdapter != null) {
            this.jpaVendorAdapter.postProcessEntityManagerFactory(this.nativeEntityManagerFactory);
        }
        this.entityManagerFactory = this.createEntityManagerFactoryProxy(this.nativeEntityManagerFactory);
    }

    protected EntityManagerFactory createEntityManagerFactoryProxy(EntityManagerFactory emf) {
        LinkedHashSet ifcs = new LinkedHashSet();
        if (this.entityManagerFactoryInterface != null) {
            ifcs.add(this.entityManagerFactoryInterface);
        } else {
            ifcs.addAll(ClassUtils.getAllInterfacesForClassAsSet(emf.getClass(), this.beanClassLoader));
        }
        ifcs.add(EntityManagerFactoryInfo.class);
        try {
            return (EntityManagerFactory)Proxy.newProxyInstance(this.beanClassLoader, ifcs.toArray(new Class[ifcs.size()]), (InvocationHandler)new ManagedEntityManagerFactoryInvocationHandler(this));
        }
        catch (IllegalArgumentException ex) {
            if (this.entityManagerFactoryInterface != null) {
                throw new IllegalStateException("EntityManagerFactory interface [" + this.entityManagerFactoryInterface + "] seems to conflict with Spring's EntityManagerFactoryInfo mixin - consider resetting the " + "'entityManagerFactoryInterface' property to plain [javax.persistence.EntityManagerFactory]", ex);
            }
            throw new IllegalStateException("Conflicting EntityManagerFactory interfaces - consider specifying the 'jpaVendorAdapter' or 'entityManagerFactoryInterface' property to select a specific EntityManagerFactory interface to proceed with", ex);
        }
    }

    Object invokeProxyMethod(Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().isAssignableFrom(EntityManagerFactoryInfo.class)) {
            return method.invoke((Object)this, args);
        }
        if (method.getName().equals("createEntityManager") && args != null && args.length > 0 && args[0] != null && args[0].getClass().isEnum() && "SYNCHRONIZED".equals(args[0].toString())) {
            EntityManager rawEntityManager = args.length > 1 ? this.nativeEntityManagerFactory.createEntityManager((Map)args[1]) : this.nativeEntityManagerFactory.createEntityManager();
            return ExtendedEntityManagerCreator.createApplicationManagedEntityManager(rawEntityManager, this, true);
        }
        Object retVal = method.invoke((Object)this.nativeEntityManagerFactory, args);
        if (retVal instanceof EntityManager) {
            EntityManager rawEntityManager = (EntityManager)retVal;
            retVal = ExtendedEntityManagerCreator.createApplicationManagedEntityManager(rawEntityManager, this, false);
        }
        return retVal;
    }

    protected abstract EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException;

    @Override
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.jpaDialect != null ? this.jpaDialect.translateExceptionIfPossible(ex) : EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    @Override
    public EntityManagerFactory getNativeEntityManagerFactory() {
        return this.nativeEntityManagerFactory;
    }

    @Override
    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return null;
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    @Override
    public EntityManagerFactory getObject() {
        return this.entityManagerFactory;
    }

    @Override
    public Class<? extends EntityManagerFactory> getObjectType() {
        return this.entityManagerFactory != null ? this.entityManagerFactory.getClass() : EntityManagerFactory.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void destroy() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Closing JPA EntityManagerFactory for persistence unit '" + this.getPersistenceUnitName() + "'");
        }
        this.entityManagerFactory.close();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("An EntityManagerFactoryBean itself is not deserializable - just a SerializedEntityManagerFactoryBeanReference is");
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.beanFactory != null && this.beanName != null) {
            return new SerializedEntityManagerFactoryBeanReference(this.beanFactory, this.beanName);
        }
        throw new NotSerializableException("EntityManagerFactoryBean does not run within a BeanFactory");
    }

    private static class ManagedEntityManagerFactoryInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final AbstractEntityManagerFactoryBean entityManagerFactoryBean;

        public ManagedEntityManagerFactoryInvocationHandler(AbstractEntityManagerFactoryBean emfb) {
            this.entityManagerFactoryBean = emfb;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Class targetClass;
                if (method.getName().equals("equals")) {
                    return proxy == args[0];
                }
                if (method.getName().equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                if (method.getName().equals("unwrap") && ((targetClass = (Class)args[0]) == null || targetClass.isInstance(proxy))) {
                    return proxy;
                }
                return this.entityManagerFactoryBean.invokeProxyMethod(method, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class SerializedEntityManagerFactoryBeanReference
    implements Serializable {
        private final BeanFactory beanFactory;
        private final String lookupName;

        public SerializedEntityManagerFactoryBeanReference(BeanFactory beanFactory, String beanName) {
            this.beanFactory = beanFactory;
            this.lookupName = "&" + beanName;
        }

        private Object readResolve() {
            return this.beanFactory.getBean(this.lookupName, AbstractEntityManagerFactoryBean.class);
        }
    }
}

