/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import javax.sql.DataSource;
import org.evosuite.shaded.org.springframework.beans.BeansException;
import org.evosuite.shaded.org.springframework.beans.factory.BeanFactory;
import org.evosuite.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.evosuite.shaded.org.springframework.beans.factory.InitializingBean;
import org.evosuite.shaded.org.springframework.beans.factory.ListableBeanFactory;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.support.DataAccessUtils;
import org.evosuite.shaded.org.springframework.jdbc.datasource.ConnectionHandle;
import org.evosuite.shaded.org.springframework.jdbc.datasource.ConnectionHolder;
import org.evosuite.shaded.org.springframework.jdbc.datasource.JdbcTransactionObjectSupport;
import org.evosuite.shaded.org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.evosuite.shaded.org.springframework.orm.jpa.DefaultJpaDialect;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerHolder;
import org.evosuite.shaded.org.springframework.orm.jpa.JpaDialect;
import org.evosuite.shaded.org.springframework.transaction.CannotCreateTransactionException;
import org.evosuite.shaded.org.springframework.transaction.IllegalTransactionStateException;
import org.evosuite.shaded.org.springframework.transaction.NestedTransactionNotSupportedException;
import org.evosuite.shaded.org.springframework.transaction.SavepointManager;
import org.evosuite.shaded.org.springframework.transaction.TransactionDefinition;
import org.evosuite.shaded.org.springframework.transaction.TransactionException;
import org.evosuite.shaded.org.springframework.transaction.TransactionSystemException;
import org.evosuite.shaded.org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.evosuite.shaded.org.springframework.transaction.support.DefaultTransactionStatus;
import org.evosuite.shaded.org.springframework.transaction.support.DelegatingTransactionDefinition;
import org.evosuite.shaded.org.springframework.transaction.support.ResourceTransactionManager;
import org.evosuite.shaded.org.springframework.transaction.support.TransactionSynchronizationManager;
import org.evosuite.shaded.org.springframework.util.CollectionUtils;

public class JpaTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
BeanFactoryAware,
InitializingBean {
    private EntityManagerFactory entityManagerFactory;
    private String persistenceUnitName;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();
    private DataSource dataSource;
    private JpaDialect jpaDialect = new DefaultJpaDialect();

    public JpaTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public JpaTransactionManager(EntityManagerFactory emf) {
        this();
        this.entityManagerFactory = emf;
        this.afterPropertiesSet();
    }

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setJpaProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap(jpaProperties, this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(Map<String, ?> jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setJpaDialect(JpaDialect jpaDialect) {
        this.jpaDialect = jpaDialect != null ? jpaDialect : new DefaultJpaDialect();
    }

    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.getEntityManagerFactory() == null) {
            if (!(beanFactory instanceof ListableBeanFactory)) {
                throw new IllegalStateException("Cannot retrieve EntityManagerFactory by persistence unit name in a non-listable BeanFactory: " + beanFactory);
            }
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            this.setEntityManagerFactory(EntityManagerFactoryUtils.findEntityManagerFactory(lbf, this.getPersistenceUnitName()));
        }
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getEntityManagerFactory() == null) {
            throw new IllegalArgumentException("'entityManagerFactory' or 'persistenceUnitName' is required");
        }
        if (this.getEntityManagerFactory() instanceof EntityManagerFactoryInfo) {
            JpaDialect jpaDialect;
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)((Object)this.getEntityManagerFactory());
            DataSource dataSource = emfInfo.getDataSource();
            if (dataSource != null) {
                this.setDataSource(dataSource);
            }
            if ((jpaDialect = emfInfo.getJpaDialect()) != null) {
                this.setJpaDialect(jpaDialect);
            }
        }
    }

    @Override
    public Object getResourceFactory() {
        return this.getEntityManagerFactory();
    }

    @Override
    protected Object doGetTransaction() {
        JpaTransactionObject txObject = new JpaTransactionObject();
        txObject.setSavepointAllowed(this.isNestedTransactionAllowed());
        EntityManagerHolder emHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource(this.getEntityManagerFactory());
        if (emHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found thread-bound EntityManager [" + emHolder.getEntityManager() + "] for JPA transaction");
            }
            txObject.setEntityManagerHolder(emHolder, false);
        }
        if (this.getDataSource() != null) {
            ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(this.getDataSource());
            txObject.setConnectionHolder(conHolder);
        }
        return txObject;
    }

    @Override
    protected boolean isExistingTransaction(Object transaction) {
        return ((JpaTransactionObject)transaction).hasTransaction();
    }

    @Override
    protected void doBegin(Object transaction, TransactionDefinition definition) {
        JpaTransactionObject txObject = (JpaTransactionObject)transaction;
        if (txObject.hasConnectionHolder() && !txObject.getConnectionHolder().isSynchronizedWithTransaction()) {
            throw new IllegalTransactionStateException("Pre-bound JDBC Connection found! JpaTransactionManager does not support running within DataSourceTransactionManager if told to manage the DataSource itself. It is recommended to use a single JpaTransactionManager for all transactions on a single DataSource, no matter whether JPA or JDBC access.");
        }
        try {
            if (txObject.getEntityManagerHolder() == null || txObject.getEntityManagerHolder().isSynchronizedWithTransaction()) {
                EntityManager newEm = this.createEntityManagerForTransaction();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Opened new EntityManager [" + newEm + "] for JPA transaction");
                }
                txObject.setEntityManagerHolder(new EntityManagerHolder(newEm), true);
            }
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            final int timeoutToUse = this.determineTimeout(definition);
            Object transactionData = this.getJpaDialect().beginTransaction(em, new DelegatingTransactionDefinition(definition){

                @Override
                public int getTimeout() {
                    return timeoutToUse;
                }
            });
            txObject.setTransactionData(transactionData);
            if (timeoutToUse != -1) {
                txObject.getEntityManagerHolder().setTimeoutInSeconds(timeoutToUse);
            }
            if (this.getDataSource() != null) {
                ConnectionHandle conHandle = this.getJpaDialect().getJdbcConnection(em, definition.isReadOnly());
                if (conHandle != null) {
                    ConnectionHolder conHolder = new ConnectionHolder(conHandle);
                    if (timeoutToUse != -1) {
                        conHolder.setTimeoutInSeconds(timeoutToUse);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Exposing JPA transaction as JDBC transaction [" + conHolder.getConnectionHandle() + "]");
                    }
                    TransactionSynchronizationManager.bindResource(this.getDataSource(), conHolder);
                    txObject.setConnectionHolder(conHolder);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Not exposing JPA transaction [" + em + "] as JDBC transaction because " + "JpaDialect [" + this.getJpaDialect() + "] does not support JDBC Connection retrieval");
                }
            }
            if (txObject.isNewEntityManagerHolder()) {
                TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), txObject.getEntityManagerHolder());
            }
            txObject.getEntityManagerHolder().setSynchronizedWithTransaction(true);
        }
        catch (TransactionException ex) {
            this.closeEntityManagerAfterFailedBegin(txObject);
            throw ex;
        }
        catch (Throwable ex) {
            this.closeEntityManagerAfterFailedBegin(txObject);
            throw new CannotCreateTransactionException("Could not open JPA EntityManager for transaction", ex);
        }
    }

    protected EntityManager createEntityManagerForTransaction() {
        Map<String, Object> properties;
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf instanceof EntityManagerFactoryInfo) {
            emf = ((EntityManagerFactoryInfo)((Object)emf)).getNativeEntityManagerFactory();
        }
        return !CollectionUtils.isEmpty(properties = this.getJpaPropertyMap()) ? emf.createEntityManager(properties) : emf.createEntityManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeEntityManagerAfterFailedBegin(JpaTransactionObject txObject) {
        if (txObject.isNewEntityManagerHolder()) {
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            try {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
            }
            catch (Throwable ex) {
                this.logger.debug("Could not rollback EntityManager after failed transaction begin", ex);
            }
            finally {
                EntityManagerFactoryUtils.closeEntityManager(em);
            }
            txObject.setEntityManagerHolder(null, false);
        }
    }

    @Override
    protected Object doSuspend(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)transaction;
        txObject.setEntityManagerHolder(null, false);
        EntityManagerHolder entityManagerHolder = (EntityManagerHolder)TransactionSynchronizationManager.unbindResource(this.getEntityManagerFactory());
        txObject.setConnectionHolder(null);
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null && TransactionSynchronizationManager.hasResource(this.getDataSource())) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        return new SuspendedResourcesHolder(entityManagerHolder, connectionHolder);
    }

    @Override
    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.getEntityManagerFactory(), resourcesHolder.getEntityManagerHolder());
        if (this.getDataSource() != null && resourcesHolder.getConnectionHolder() != null) {
            TransactionSynchronizationManager.bindResource(this.getDataSource(), resourcesHolder.getConnectionHolder());
        }
    }

    @Override
    protected boolean shouldCommitOnGlobalRollbackOnly() {
        return true;
    }

    @Override
    protected void doCommit(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Committing JPA transaction on EntityManager [" + txObject.getEntityManagerHolder().getEntityManager() + "]");
        }
        try {
            EntityTransaction tx = txObject.getEntityManagerHolder().getEntityManager().getTransaction();
            tx.commit();
        }
        catch (RollbackException ex) {
            DataAccessException dex;
            if (ex.getCause() instanceof RuntimeException && (dex = this.getJpaDialect().translateExceptionIfPossible((RuntimeException)ex.getCause())) != null) {
                throw dex;
            }
            throw new TransactionSystemException("Could not commit JPA transaction", ex);
        }
        catch (RuntimeException ex) {
            throw DataAccessUtils.translateIfNecessary(ex, this.getJpaDialect());
        }
    }

    @Override
    protected void doRollback(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Rolling back JPA transaction on EntityManager [" + txObject.getEntityManagerHolder().getEntityManager() + "]");
        }
        try {
            EntityTransaction tx = txObject.getEntityManagerHolder().getEntityManager().getTransaction();
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        catch (PersistenceException ex) {
            throw new TransactionSystemException("Could not roll back JPA transaction", ex);
        }
        finally {
            if (!txObject.isNewEntityManagerHolder()) {
                txObject.getEntityManagerHolder().getEntityManager().clear();
            }
        }
    }

    @Override
    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JpaTransactionObject txObject = (JpaTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug("Setting JPA transaction on EntityManager [" + txObject.getEntityManagerHolder().getEntityManager() + "] rollback-only");
        }
        txObject.setRollbackOnly();
    }

    @Override
    protected void doCleanupAfterCompletion(Object transaction) {
        JpaTransactionObject txObject = (JpaTransactionObject)transaction;
        if (txObject.isNewEntityManagerHolder()) {
            TransactionSynchronizationManager.unbindResourceIfPossible(this.getEntityManagerFactory());
        }
        txObject.getEntityManagerHolder().clear();
        if (txObject.hasConnectionHolder()) {
            TransactionSynchronizationManager.unbindResource(this.getDataSource());
            try {
                this.getJpaDialect().releaseJdbcConnection(txObject.getConnectionHolder().getConnectionHandle(), txObject.getEntityManagerHolder().getEntityManager());
            }
            catch (Exception ex) {
                this.logger.error("Could not close JDBC connection after transaction", ex);
            }
        }
        this.getJpaDialect().cleanupTransaction(txObject.getTransactionData());
        if (txObject.isNewEntityManagerHolder()) {
            EntityManager em = txObject.getEntityManagerHolder().getEntityManager();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Closing JPA EntityManager [" + em + "] after transaction");
            }
            EntityManagerFactoryUtils.closeEntityManager(em);
        } else {
            this.logger.debug("Not closing pre-bound JPA EntityManager after transaction");
        }
    }

    private static class SuspendedResourcesHolder {
        private final EntityManagerHolder entityManagerHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(EntityManagerHolder emHolder, ConnectionHolder conHolder) {
            this.entityManagerHolder = emHolder;
            this.connectionHolder = conHolder;
        }

        private EntityManagerHolder getEntityManagerHolder() {
            return this.entityManagerHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }

    private class JpaTransactionObject
    extends JdbcTransactionObjectSupport {
        private EntityManagerHolder entityManagerHolder;
        private boolean newEntityManagerHolder;
        private Object transactionData;

        private JpaTransactionObject() {
        }

        public void setEntityManagerHolder(EntityManagerHolder entityManagerHolder, boolean newEntityManagerHolder) {
            this.entityManagerHolder = entityManagerHolder;
            this.newEntityManagerHolder = newEntityManagerHolder;
        }

        public EntityManagerHolder getEntityManagerHolder() {
            return this.entityManagerHolder;
        }

        public boolean isNewEntityManagerHolder() {
            return this.newEntityManagerHolder;
        }

        public boolean hasTransaction() {
            return this.entityManagerHolder != null && this.entityManagerHolder.isTransactionActive();
        }

        public void setTransactionData(Object transactionData) {
            this.transactionData = transactionData;
            this.entityManagerHolder.setTransactionActive(true);
            if (transactionData instanceof SavepointManager) {
                this.entityManagerHolder.setSavepointManager((SavepointManager)transactionData);
            }
        }

        public Object getTransactionData() {
            return this.transactionData;
        }

        public void setRollbackOnly() {
            EntityTransaction tx = this.entityManagerHolder.getEntityManager().getTransaction();
            if (tx.isActive()) {
                tx.setRollbackOnly();
            }
            if (this.hasConnectionHolder()) {
                this.getConnectionHolder().setRollbackOnly();
            }
        }

        @Override
        public boolean isRollbackOnly() {
            EntityTransaction tx = this.entityManagerHolder.getEntityManager().getTransaction();
            return tx.getRollbackOnly();
        }

        @Override
        public void flush() {
            try {
                this.entityManagerHolder.getEntityManager().flush();
            }
            catch (RuntimeException ex) {
                throw DataAccessUtils.translateIfNecessary(ex, JpaTransactionManager.this.getJpaDialect());
            }
        }

        @Override
        public Object createSavepoint() throws TransactionException {
            return this.getSavepointManager().createSavepoint();
        }

        @Override
        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this.getSavepointManager().rollbackToSavepoint(savepoint);
        }

        @Override
        public void releaseSavepoint(Object savepoint) throws TransactionException {
            this.getSavepointManager().releaseSavepoint(savepoint);
        }

        private SavepointManager getSavepointManager() {
            if (!this.isSavepointAllowed()) {
                throw new NestedTransactionNotSupportedException("Transaction manager does not allow nested transactions");
            }
            SavepointManager savepointManager = this.getEntityManagerHolder().getSavepointManager();
            if (savepointManager == null) {
                throw new NestedTransactionNotSupportedException("JpaDialect does not support savepoints - check your JPA provider's capabilities");
            }
            return savepointManager;
        }
    }
}

