/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jpa.persistenceunit;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.evosuite.shaded.org.apache.commons.logging.Log;
import org.evosuite.shaded.org.apache.commons.logging.LogFactory;
import org.evosuite.shaded.org.springframework.beans.factory.InitializingBean;
import org.evosuite.shaded.org.springframework.context.ResourceLoaderAware;
import org.evosuite.shaded.org.springframework.context.weaving.LoadTimeWeaverAware;
import org.evosuite.shaded.org.springframework.core.io.Resource;
import org.evosuite.shaded.org.springframework.core.io.ResourceLoader;
import org.evosuite.shaded.org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.evosuite.shaded.org.springframework.core.io.support.ResourcePatternResolver;
import org.evosuite.shaded.org.springframework.core.io.support.ResourcePatternUtils;
import org.evosuite.shaded.org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.evosuite.shaded.org.springframework.core.type.classreading.MetadataReader;
import org.evosuite.shaded.org.springframework.core.type.classreading.MetadataReaderFactory;
import org.evosuite.shaded.org.springframework.core.type.filter.AnnotationTypeFilter;
import org.evosuite.shaded.org.springframework.core.type.filter.TypeFilter;
import org.evosuite.shaded.org.springframework.instrument.classloading.InstrumentationLoadTimeWeaver;
import org.evosuite.shaded.org.springframework.instrument.classloading.LoadTimeWeaver;
import org.evosuite.shaded.org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.evosuite.shaded.org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.evosuite.shaded.org.springframework.jdbc.datasource.lookup.MapDataSourceLookup;
import org.evosuite.shaded.org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.evosuite.shaded.org.springframework.orm.jpa.persistenceunit.PersistenceUnitManager;
import org.evosuite.shaded.org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.evosuite.shaded.org.springframework.orm.jpa.persistenceunit.PersistenceUnitReader;
import org.evosuite.shaded.org.springframework.orm.jpa.persistenceunit.SpringPersistenceUnitInfo;
import org.evosuite.shaded.org.springframework.util.ClassUtils;
import org.evosuite.shaded.org.springframework.util.ObjectUtils;
import org.evosuite.shaded.org.springframework.util.ResourceUtils;

public class DefaultPersistenceUnitManager
implements PersistenceUnitManager,
ResourceLoaderAware,
LoadTimeWeaverAware,
InitializingBean {
    private static final String CLASS_RESOURCE_PATTERN = "/**/*.class";
    private static final String PACKAGE_INFO_SUFFIX = ".package-info";
    private static final String DEFAULT_ORM_XML_RESOURCE = "META-INF/orm.xml";
    private static final String PERSISTENCE_XML_FILENAME = "persistence.xml";
    public static final String DEFAULT_PERSISTENCE_XML_LOCATION = "classpath*:META-INF/persistence.xml";
    public static final String ORIGINAL_DEFAULT_PERSISTENCE_UNIT_ROOT_LOCATION = "classpath:";
    public static final String ORIGINAL_DEFAULT_PERSISTENCE_UNIT_NAME = "default";
    private static final Set<TypeFilter> entityTypeFilters = new LinkedHashSet<TypeFilter>(4);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String[] persistenceXmlLocations = new String[]{"classpath*:META-INF/persistence.xml"};
    private String defaultPersistenceUnitRootLocation = "classpath:";
    private String defaultPersistenceUnitName = "default";
    private String[] packagesToScan;
    private String[] mappingResources;
    private SharedCacheMode sharedCacheMode;
    private ValidationMode validationMode;
    private DataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
    private DataSource defaultDataSource;
    private DataSource defaultJtaDataSource;
    private PersistenceUnitPostProcessor[] persistenceUnitPostProcessors;
    private LoadTimeWeaver loadTimeWeaver;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private final Set<String> persistenceUnitInfoNames = new HashSet<String>();
    private final Map<String, PersistenceUnitInfo> persistenceUnitInfos = new HashMap<String, PersistenceUnitInfo>();

    public void setPersistenceXmlLocation(String persistenceXmlLocation) {
        this.persistenceXmlLocations = new String[]{persistenceXmlLocation};
    }

    public void setPersistenceXmlLocations(String ... persistenceXmlLocations) {
        this.persistenceXmlLocations = persistenceXmlLocations;
    }

    public void setDefaultPersistenceUnitRootLocation(String defaultPersistenceUnitRootLocation) {
        this.defaultPersistenceUnitRootLocation = defaultPersistenceUnitRootLocation;
    }

    public void setDefaultPersistenceUnitName(String defaultPersistenceUnitName) {
        this.defaultPersistenceUnitName = defaultPersistenceUnitName;
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void setMappingResources(String ... mappingResources) {
        this.mappingResources = mappingResources;
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public void setDataSources(Map<String, DataSource> dataSources) {
        this.dataSourceLookup = new MapDataSourceLookup(dataSources);
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        this.dataSourceLookup = dataSourceLookup != null ? dataSourceLookup : new JndiDataSourceLookup();
    }

    public DataSourceLookup getDataSourceLookup() {
        return this.dataSourceLookup;
    }

    public void setDefaultDataSource(DataSource defaultDataSource) {
        this.defaultDataSource = defaultDataSource;
    }

    public DataSource getDefaultDataSource() {
        return this.defaultDataSource;
    }

    public void setDefaultJtaDataSource(DataSource defaultJtaDataSource) {
        this.defaultJtaDataSource = defaultJtaDataSource;
    }

    public DataSource getDefaultJtaDataSource() {
        return this.defaultJtaDataSource;
    }

    public void setPersistenceUnitPostProcessors(PersistenceUnitPostProcessor ... postProcessors) {
        this.persistenceUnitPostProcessors = postProcessors;
    }

    public PersistenceUnitPostProcessor[] getPersistenceUnitPostProcessors() {
        return this.persistenceUnitPostProcessors;
    }

    @Override
    public void setLoadTimeWeaver(LoadTimeWeaver loadTimeWeaver) {
        this.loadTimeWeaver = loadTimeWeaver;
    }

    public LoadTimeWeaver getLoadTimeWeaver() {
        return this.loadTimeWeaver;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
    }

    @Override
    public void afterPropertiesSet() {
        if (this.loadTimeWeaver == null && InstrumentationLoadTimeWeaver.isInstrumentationAvailable()) {
            this.loadTimeWeaver = new InstrumentationLoadTimeWeaver(this.resourcePatternResolver.getClassLoader());
        }
        this.preparePersistenceUnitInfos();
    }

    public void preparePersistenceUnitInfos() {
        this.persistenceUnitInfoNames.clear();
        this.persistenceUnitInfos.clear();
        List<SpringPersistenceUnitInfo> puis = this.readPersistenceUnitInfos();
        for (SpringPersistenceUnitInfo pui : puis) {
            if (pui.getPersistenceUnitRootUrl() == null) {
                pui.setPersistenceUnitRootUrl(this.determineDefaultPersistenceUnitRootUrl());
            }
            if (pui.getJtaDataSource() == null) {
                pui.setJtaDataSource(this.defaultJtaDataSource);
            }
            if (pui.getNonJtaDataSource() == null) {
                pui.setNonJtaDataSource(this.defaultDataSource);
            }
            if (this.sharedCacheMode != null) {
                pui.setSharedCacheMode(this.sharedCacheMode);
            }
            if (this.validationMode != null) {
                pui.setValidationMode(this.validationMode);
            }
            if (this.loadTimeWeaver != null) {
                pui.init(this.loadTimeWeaver);
            } else {
                pui.init(this.resourcePatternResolver.getClassLoader());
            }
            this.postProcessPersistenceUnitInfo(pui);
            String name = pui.getPersistenceUnitName();
            if (!this.persistenceUnitInfoNames.add(name) && !this.isPersistenceUnitOverrideAllowed()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Conflicting persistence unit definitions for name '").append(name).append("': ");
                msg.append(pui.getPersistenceUnitRootUrl()).append(", ");
                msg.append(this.persistenceUnitInfos.get(name).getPersistenceUnitRootUrl());
                throw new IllegalStateException(msg.toString());
            }
            this.persistenceUnitInfos.put(name, pui);
        }
    }

    private List<SpringPersistenceUnitInfo> readPersistenceUnitInfos() {
        SpringPersistenceUnitInfo[] readInfos;
        LinkedList<SpringPersistenceUnitInfo> infos = new LinkedList<SpringPersistenceUnitInfo>();
        String defaultName = this.defaultPersistenceUnitName;
        boolean buildDefaultUnit = this.packagesToScan != null || this.mappingResources != null;
        boolean foundDefaultUnit = false;
        PersistenceUnitReader reader = new PersistenceUnitReader(this.resourcePatternResolver, this.dataSourceLookup);
        for (SpringPersistenceUnitInfo readInfo : readInfos = reader.readPersistenceUnitInfos(this.persistenceXmlLocations)) {
            infos.add(readInfo);
            if (defaultName == null || !defaultName.equals(readInfo.getPersistenceUnitName())) continue;
            foundDefaultUnit = true;
        }
        if (buildDefaultUnit) {
            if (foundDefaultUnit) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Found explicit default unit with name '" + defaultName + "' in persistence.xml - " + "overriding local default unit settings ('packagesToScan'/'mappingResources')");
                }
            } else {
                infos.add(this.buildDefaultPersistenceUnitInfo());
            }
        }
        return infos;
    }

    private SpringPersistenceUnitInfo buildDefaultPersistenceUnitInfo() {
        SpringPersistenceUnitInfo scannedUnit = new SpringPersistenceUnitInfo();
        scannedUnit.setPersistenceUnitName(this.defaultPersistenceUnitName);
        scannedUnit.setExcludeUnlistedClasses(true);
        if (this.packagesToScan != null) {
            for (String pkg : this.packagesToScan) {
                try {
                    String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath(pkg) + CLASS_RESOURCE_PATTERN;
                    Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                    CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory(this.resourcePatternResolver);
                    for (Resource resource : resources) {
                        if (!resource.isReadable()) continue;
                        MetadataReader reader = readerFactory.getMetadataReader(resource);
                        String className = reader.getClassMetadata().getClassName();
                        if (this.matchesFilter(reader, readerFactory)) {
                            URL url;
                            scannedUnit.addManagedClassName(className);
                            if (scannedUnit.getPersistenceUnitRootUrl() != null || !ResourceUtils.isJarURL(url = resource.getURL())) continue;
                            scannedUnit.setPersistenceUnitRootUrl(ResourceUtils.extractJarFileURL(url));
                            continue;
                        }
                        if (!className.endsWith(PACKAGE_INFO_SUFFIX)) continue;
                        scannedUnit.addManagedPackage(className.substring(0, className.length() - PACKAGE_INFO_SUFFIX.length()));
                    }
                }
                catch (IOException ex) {
                    throw new PersistenceException("Failed to scan classpath for unlisted entity classes", ex);
                }
            }
        }
        if (this.mappingResources != null) {
            for (String mappingFileName : this.mappingResources) {
                scannedUnit.addMappingFileName(mappingFileName);
            }
        } else if (this.useOrmXmlForDefaultPersistenceUnit()) {
            scannedUnit.addMappingFileName(DEFAULT_ORM_XML_RESOURCE);
        }
        return scannedUnit;
    }

    private boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter filter : entityTypeFilters) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }

    private URL determineDefaultPersistenceUnitRootUrl() {
        if (this.defaultPersistenceUnitRootLocation == null) {
            return null;
        }
        try {
            Resource res = this.resourcePatternResolver.getResource(this.defaultPersistenceUnitRootLocation);
            return res.getURL();
        }
        catch (IOException ex) {
            throw new PersistenceException("Unable to resolve persistence unit root URL", ex);
        }
    }

    private boolean useOrmXmlForDefaultPersistenceUnit() {
        Resource ormXml = this.resourcePatternResolver.getResource(this.defaultPersistenceUnitRootLocation + DEFAULT_ORM_XML_RESOURCE);
        if (ormXml.exists()) {
            try {
                Resource persistenceXml = ormXml.createRelative(PERSISTENCE_XML_FILENAME);
                if (!persistenceXml.exists()) {
                    return true;
                }
            }
            catch (IOException ex) {
                return true;
            }
        }
        return false;
    }

    protected final MutablePersistenceUnitInfo getPersistenceUnitInfo(String persistenceUnitName) {
        PersistenceUnitInfo pui = this.persistenceUnitInfos.get(persistenceUnitName);
        return (MutablePersistenceUnitInfo)pui;
    }

    protected void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        PersistenceUnitPostProcessor[] postProcessors = this.getPersistenceUnitPostProcessors();
        if (postProcessors != null) {
            for (PersistenceUnitPostProcessor postProcessor : postProcessors) {
                postProcessor.postProcessPersistenceUnitInfo(pui);
            }
        }
    }

    protected boolean isPersistenceUnitOverrideAllowed() {
        return false;
    }

    @Override
    public PersistenceUnitInfo obtainDefaultPersistenceUnitInfo() {
        if (this.persistenceUnitInfoNames.isEmpty()) {
            throw new IllegalStateException("No persistence units parsed from " + ObjectUtils.nullSafeToString(this.persistenceXmlLocations));
        }
        if (this.persistenceUnitInfos.isEmpty()) {
            throw new IllegalStateException("All persistence units from " + ObjectUtils.nullSafeToString(this.persistenceXmlLocations) + " already obtained");
        }
        if (this.persistenceUnitInfos.size() > 1) {
            return this.obtainPersistenceUnitInfo(this.defaultPersistenceUnitName);
        }
        PersistenceUnitInfo pui = this.persistenceUnitInfos.values().iterator().next();
        this.persistenceUnitInfos.clear();
        return pui;
    }

    @Override
    public PersistenceUnitInfo obtainPersistenceUnitInfo(String persistenceUnitName) {
        PersistenceUnitInfo pui = this.persistenceUnitInfos.remove(persistenceUnitName);
        if (pui == null) {
            if (!this.persistenceUnitInfoNames.contains(persistenceUnitName)) {
                throw new IllegalArgumentException("No persistence unit with name '" + persistenceUnitName + "' found");
            }
            throw new IllegalStateException("Persistence unit with name '" + persistenceUnitName + "' already obtained");
        }
        return pui;
    }

    static {
        entityTypeFilters.add(new AnnotationTypeFilter(Entity.class, false));
        entityTypeFilters.add(new AnnotationTypeFilter(Embeddable.class, false));
        entityTypeFilters.add(new AnnotationTypeFilter(MappedSuperclass.class, false));
        try {
            Class<?> converterAnnotation = ClassUtils.forName("javax.persistence.Converter", DefaultPersistenceUnitManager.class.getClassLoader());
            entityTypeFilters.add(new AnnotationTypeFilter(converterAnnotation, false));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

