/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jpa.support;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.evosuite.shaded.org.springframework.beans.factory.FactoryBean;
import org.evosuite.shaded.org.springframework.beans.factory.InitializingBean;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryAccessor;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.evosuite.shaded.org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.evosuite.shaded.org.springframework.util.Assert;

public class SharedEntityManagerBean
extends EntityManagerFactoryAccessor
implements FactoryBean<EntityManager>,
InitializingBean {
    private Class<? extends EntityManager> entityManagerInterface;
    private boolean synchronizedWithTransaction = true;
    private EntityManager shared;

    public void setEntityManagerInterface(Class<? extends EntityManager> entityManagerInterface) {
        Assert.notNull(entityManagerInterface, "'entityManagerInterface' must not be null");
        Assert.isAssignable(EntityManager.class, entityManagerInterface);
        this.entityManagerInterface = entityManagerInterface;
    }

    public void setSynchronizedWithTransaction(boolean synchronizedWithTransaction) {
        this.synchronizedWithTransaction = synchronizedWithTransaction;
    }

    @Override
    public final void afterPropertiesSet() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        if (emf == null) {
            throw new IllegalArgumentException("'entityManagerFactory' or 'persistenceUnitName' is required");
        }
        if (emf instanceof EntityManagerFactoryInfo) {
            EntityManagerFactoryInfo emfInfo = (EntityManagerFactoryInfo)((Object)emf);
            if (this.entityManagerInterface == null) {
                this.entityManagerInterface = emfInfo.getEntityManagerInterface();
                if (this.entityManagerInterface == null) {
                    this.entityManagerInterface = EntityManager.class;
                }
            }
        } else if (this.entityManagerInterface == null) {
            this.entityManagerInterface = EntityManager.class;
        }
        this.shared = SharedEntityManagerCreator.createSharedEntityManager(emf, this.getJpaPropertyMap(), this.synchronizedWithTransaction, this.entityManagerInterface);
    }

    @Override
    public EntityManager getObject() {
        return this.shared;
    }

    @Override
    public Class<? extends EntityManager> getObjectType() {
        return this.entityManagerInterface != null ? this.entityManagerInterface : EntityManager.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

