/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jpa.vendor;

import java.lang.reflect.Method;
import javax.persistence.EntityManagerFactory;
import org.evosuite.shaded.org.hibernate.SessionFactory;
import org.evosuite.shaded.org.springframework.beans.factory.FactoryBean;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryAccessor;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.ReflectionUtils;

public class HibernateJpaSessionFactoryBean
extends EntityManagerFactoryAccessor
implements FactoryBean<SessionFactory> {
    @Override
    public SessionFactory getObject() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state(emf != null, "EntityManagerFactory must not be null");
        try {
            Method getSessionFactory = emf.getClass().getMethod("getSessionFactory", new Class[0]);
            return (SessionFactory)ReflectionUtils.invokeMethod(getSessionFactory, emf);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("No compatible Hibernate EntityManagerFactory found: " + ex);
        }
    }

    @Override
    public Class<?> getObjectType() {
        return SessionFactory.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

