/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.transaction.config;

import org.evosuite.shaded.org.springframework.aop.config.AopNamespaceUtils;
import org.evosuite.shaded.org.springframework.beans.factory.config.BeanDefinition;
import org.evosuite.shaded.org.springframework.beans.factory.config.RuntimeBeanReference;
import org.evosuite.shaded.org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.evosuite.shaded.org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.evosuite.shaded.org.springframework.beans.factory.support.RootBeanDefinition;
import org.evosuite.shaded.org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.evosuite.shaded.org.springframework.beans.factory.xml.ParserContext;
import org.evosuite.shaded.org.springframework.transaction.config.TxNamespaceHandler;
import org.evosuite.shaded.org.springframework.transaction.interceptor.BeanFactoryTransactionAttributeSourceAdvisor;
import org.evosuite.shaded.org.springframework.transaction.interceptor.TransactionInterceptor;
import org.w3c.dom.Element;

class AnnotationDrivenBeanDefinitionParser
implements BeanDefinitionParser {
    @Deprecated
    public static final String TRANSACTION_ADVISOR_BEAN_NAME = "org.evosuite.shaded.org.springframework.transaction.config.internalTransactionAdvisor";
    @Deprecated
    public static final String TRANSACTION_ASPECT_BEAN_NAME = "org.evosuite.shaded.org.springframework.transaction.config.internalTransactionAspect";

    AnnotationDrivenBeanDefinitionParser() {
    }

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String mode = element.getAttribute("mode");
        if ("aspectj".equals(mode)) {
            this.registerTransactionAspect(element, parserContext);
        } else {
            AopAutoProxyConfigurer.configureAutoProxyCreator(element, parserContext);
        }
        return null;
    }

    private void registerTransactionAspect(Element element, ParserContext parserContext) {
        String txAspectBeanName = TRANSACTION_ASPECT_BEAN_NAME;
        String txAspectClassName = "org.evosuite.shaded.org.springframework.transaction.aspectj.AnnotationTransactionAspect";
        if (!parserContext.getRegistry().containsBeanDefinition(txAspectBeanName)) {
            RootBeanDefinition def = new RootBeanDefinition();
            def.setBeanClassName(txAspectClassName);
            def.setFactoryMethodName("aspectOf");
            AnnotationDrivenBeanDefinitionParser.registerTransactionManager(element, def);
            parserContext.registerBeanComponent(new BeanComponentDefinition(def, txAspectBeanName));
        }
    }

    private static void registerTransactionManager(Element element, BeanDefinition def) {
        def.getPropertyValues().add("transactionManagerBeanName", TxNamespaceHandler.getTransactionManagerName(element));
    }

    private static class AopAutoProxyConfigurer {
        private AopAutoProxyConfigurer() {
        }

        public static void configureAutoProxyCreator(Element element, ParserContext parserContext) {
            AopNamespaceUtils.registerAutoProxyCreatorIfNecessary(parserContext, element);
            String txAdvisorBeanName = AnnotationDrivenBeanDefinitionParser.TRANSACTION_ADVISOR_BEAN_NAME;
            if (!parserContext.getRegistry().containsBeanDefinition(txAdvisorBeanName)) {
                Object eleSource = parserContext.extractSource(element);
                RootBeanDefinition sourceDef = new RootBeanDefinition("org.evosuite.shaded.org.springframework.transaction.annotation.AnnotationTransactionAttributeSource");
                sourceDef.setSource(eleSource);
                sourceDef.setRole(2);
                String sourceName = parserContext.getReaderContext().registerWithGeneratedName(sourceDef);
                RootBeanDefinition interceptorDef = new RootBeanDefinition(TransactionInterceptor.class);
                interceptorDef.setSource(eleSource);
                interceptorDef.setRole(2);
                AnnotationDrivenBeanDefinitionParser.registerTransactionManager(element, interceptorDef);
                interceptorDef.getPropertyValues().add("transactionAttributeSource", new RuntimeBeanReference(sourceName));
                String interceptorName = parserContext.getReaderContext().registerWithGeneratedName(interceptorDef);
                RootBeanDefinition advisorDef = new RootBeanDefinition(BeanFactoryTransactionAttributeSourceAdvisor.class);
                advisorDef.setSource(eleSource);
                advisorDef.setRole(2);
                advisorDef.getPropertyValues().add("transactionAttributeSource", new RuntimeBeanReference(sourceName));
                advisorDef.getPropertyValues().add("adviceBeanName", interceptorName);
                if (element.hasAttribute("order")) {
                    advisorDef.getPropertyValues().add("order", element.getAttribute("order"));
                }
                parserContext.getRegistry().registerBeanDefinition(txAdvisorBeanName, advisorDef);
                CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), eleSource);
                compositeDef.addNestedComponent(new BeanComponentDefinition(sourceDef, sourceName));
                compositeDef.addNestedComponent(new BeanComponentDefinition(interceptorDef, interceptorName));
                compositeDef.addNestedComponent(new BeanComponentDefinition(advisorDef, txAdvisorBeanName));
                parserContext.registerComponent(compositeDef);
            }
        }
    }
}

