/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.util.concurrent;

import java.util.concurrent.ExecutionException;
import org.evosuite.shaded.org.springframework.util.concurrent.FailureCallback;
import org.evosuite.shaded.org.springframework.util.concurrent.FutureAdapter;
import org.evosuite.shaded.org.springframework.util.concurrent.ListenableFuture;
import org.evosuite.shaded.org.springframework.util.concurrent.ListenableFutureCallback;
import org.evosuite.shaded.org.springframework.util.concurrent.SuccessCallback;

public abstract class ListenableFutureAdapter<T, S>
extends FutureAdapter<T, S>
implements ListenableFuture<T> {
    protected ListenableFutureAdapter(ListenableFuture<S> adaptee) {
        super(adaptee);
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super T> callback) {
        this.addCallback(callback, callback);
    }

    @Override
    public void addCallback(final SuccessCallback<? super T> successCallback, final FailureCallback failureCallback) {
        ListenableFuture listenableAdaptee = (ListenableFuture)this.getAdaptee();
        listenableAdaptee.addCallback(new ListenableFutureCallback<S>(){

            @Override
            public void onSuccess(S result) {
                try {
                    successCallback.onSuccess(ListenableFutureAdapter.this.adaptInternal(result));
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    this.onFailure(cause != null ? cause : ex);
                }
                catch (Throwable ex) {
                    this.onFailure(ex);
                }
            }

            @Override
            public void onFailure(Throwable ex) {
                failureCallback.onFailure(ex);
            }
        });
    }
}

