/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.validation.beanvalidation;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import org.evosuite.shaded.org.springframework.beans.NotReadablePropertyException;
import org.evosuite.shaded.org.springframework.context.support.DefaultMessageSourceResolvable;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.validation.BindingResult;
import org.evosuite.shaded.org.springframework.validation.Errors;
import org.evosuite.shaded.org.springframework.validation.FieldError;
import org.evosuite.shaded.org.springframework.validation.ObjectError;
import org.evosuite.shaded.org.springframework.validation.SmartValidator;

public class SpringValidatorAdapter
implements SmartValidator,
Validator {
    private static final Set<String> internalAnnotationAttributes = new HashSet<String>(3);
    private Validator targetValidator;

    public SpringValidatorAdapter(Validator targetValidator) {
        Assert.notNull(targetValidator, "Target Validator must not be null");
        this.targetValidator = targetValidator;
    }

    SpringValidatorAdapter() {
    }

    void setTargetValidator(Validator targetValidator) {
        this.targetValidator = targetValidator;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return this.targetValidator != null;
    }

    @Override
    public void validate(Object target, Errors errors) {
        if (this.targetValidator != null) {
            this.processConstraintViolations(this.targetValidator.validate(target, new Class[0]), errors);
        }
    }

    @Override
    public void validate(Object target, Errors errors, Object ... validationHints) {
        if (this.targetValidator != null) {
            LinkedHashSet<Class> groups = new LinkedHashSet<Class>();
            if (validationHints != null) {
                for (Object hint : validationHints) {
                    if (!(hint instanceof Class)) continue;
                    groups.add((Class)hint);
                }
            }
            this.processConstraintViolations(this.targetValidator.validate(target, groups.toArray(new Class[groups.size()])), errors);
        }
    }

    protected void processConstraintViolations(Set<ConstraintViolation<Object>> violations, Errors errors) {
        for (ConstraintViolation<Object> violation : violations) {
            String field = violation.getPropertyPath().toString();
            FieldError fieldError = errors.getFieldError(field);
            if (fieldError != null && fieldError.isBindingFailure()) continue;
            try {
                ConstraintDescriptor cd = violation.getConstraintDescriptor();
                String errorCode = cd.getAnnotation().annotationType().getSimpleName();
                Object[] errorArgs = this.getArgumentsForConstraint(errors.getObjectName(), field, cd);
                if (errors instanceof BindingResult) {
                    BindingResult bindingResult = (BindingResult)errors;
                    String nestedField = bindingResult.getNestedPath() + field;
                    if ("".equals(nestedField)) {
                        String[] errorCodes = bindingResult.resolveMessageCodes(errorCode);
                        bindingResult.addError(new ObjectError(errors.getObjectName(), errorCodes, errorArgs, violation.getMessage()));
                        continue;
                    }
                    Object invalidValue = violation.getInvalidValue();
                    if (!"".equals(field) && (invalidValue == violation.getLeafBean() || field.contains(".") && !field.contains("[]"))) {
                        invalidValue = bindingResult.getRawFieldValue(field);
                    }
                    String[] errorCodes = bindingResult.resolveMessageCodes(errorCode, field);
                    bindingResult.addError(new FieldError(errors.getObjectName(), nestedField, invalidValue, false, errorCodes, errorArgs, violation.getMessage()));
                    continue;
                }
                errors.rejectValue(field, errorCode, errorArgs, violation.getMessage());
            }
            catch (NotReadablePropertyException ex) {
                throw new IllegalStateException("JSR-303 validated property '" + field + "' does not have a corresponding accessor for Spring data binding - " + "check your DataBinder's configuration (bean property versus direct field access)", ex);
            }
        }
    }

    protected Object[] getArgumentsForConstraint(String objectName, String field, ConstraintDescriptor<?> descriptor) {
        LinkedList<DefaultMessageSourceResolvable> arguments = new LinkedList<DefaultMessageSourceResolvable>();
        String[] codes = new String[]{objectName + "." + field, field};
        arguments.add(new DefaultMessageSourceResolvable(codes, field));
        TreeMap attributesToExpose = new TreeMap();
        for (Map.Entry entry : descriptor.getAttributes().entrySet()) {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            if (internalAnnotationAttributes.contains(attributeName)) continue;
            attributesToExpose.put(attributeName, attributeValue);
        }
        arguments.addAll(attributesToExpose.values());
        return arguments.toArray(new Object[arguments.size()]);
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        Assert.notNull(this.targetValidator, "No target Validator set");
        return this.targetValidator.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        Assert.notNull(this.targetValidator, "No target Validator set");
        return this.targetValidator.validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        Assert.notNull(this.targetValidator, "No target Validator set");
        return this.targetValidator.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        Assert.notNull(this.targetValidator, "No target Validator set");
        return this.targetValidator.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        Assert.notNull(this.targetValidator, "No target Validator set");
        return (T)this.targetValidator.unwrap(type);
    }

    static {
        internalAnnotationAttributes.add("message");
        internalAnnotationAttributes.add("groups");
        internalAnnotationAttributes.add("payload");
    }
}

